jQuery(document).ready(function($) {

    // Scroll progress indicator
    $(window).scroll(function() {
        var scrolled = ($(window).scrollTop() / ($(document).height() - $(window).height())) * 100;
        $('.scroll-progress').css('width', scrolled + '%');
    });

    // Navbar scroll effect with logo switch
    $(window).scroll(function() {
        var navbar = $('.navbar');
        var mainLogo = $('.main-logo');
        var scrollLogo = $('.scroll-logo');

        if ($(window).scrollTop() > 50) {
            navbar.addClass('scrolled');
            console.log('Scrolled class added');
            if (mainLogo.length) {
                mainLogo.css('opacity', '0');
                scrollLogo.css('opacity', '1').show();
                console.log('Logo switched to scroll version');
            }
        } else {
            navbar.removeClass('scrolled');
            console.log('Scrolled class removed');
            if (mainLogo.length) {
                mainLogo.css('opacity', '1');
                scrollLogo.css('opacity', '0').hide();
            }
        }
    });

    // Ultra smooth scrolling for navigation links
    $('a[href^="#"]').on('click', function(e) {
        e.preventDefault();
        var target = $(this.getAttribute('href'));
        if (target.length) {
            var headerHeight = 80;
            var targetPosition = target.offset().top - headerHeight;

            $('html, body').animate({
                scrollTop: targetPosition
            }, 800);
        }
    });

    // Reveal animations on scroll
    var revealElements = $('.reveal');
    var revealObserver = new IntersectionObserver(function(entries) {
        entries.forEach(function(entry) {
            if (entry.isIntersecting) {
                $(entry.target).addClass('active');
            }
        });
    }, {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    });

    revealElements.each(function() {
        revealObserver.observe(this);
    });

    // Handle workshop details visibility (if contact form has these fields)
    $('.cta-form select').on('change', function() {
        var workshopDetails = $('#workshop-details');
        if (this.value === 'workshop' || this.value === 'both') {
            workshopDetails.show();
        } else {
            workshopDetails.hide();
        }
    });

    // Mobile menu toggle with animations
    $('.mobile-menu').on('click', function() {
        var navLinks = $('.nav-links');
        var mobileMenu = $('.mobile-menu');

        navLinks.toggleClass('active');
        mobileMenu.toggleClass('active');

        // Prevent body scroll when menu is open
        if (navLinks.hasClass('active')) {
            $('body').css('overflow', 'hidden');
        } else {
            $('body').css('overflow', '');
        }
    });

    // Close mobile menu when clicking a link (except dropdown trigger)
    $('.nav-links a').on('click', function() {
        // Don't close menu if this is the dropdown trigger
        if ($(this).hasClass('pricing-dropdown-link')) {
            return;
        }

        var navLinks = $('.nav-links');
        var mobileMenu = $('.mobile-menu');

        navLinks.removeClass('active');
        mobileMenu.removeClass('active');
        $('body').css('overflow', '');
    });

    // Parallax effect for decorative elements
    $(window).scroll(function() {
        var scrolled = $(window).scrollTop();
        $('.decorative-pattern').each(function(index) {
            var speed = 0.5 + (index * 0.1);
            var yPos = -(scrolled * speed);
            $(this).css('transform', 'translateY(' + yPos + 'px) rotate(' + (scrolled * 0.1) + 'deg)');
        });
    });

    // Add hover effects for interactive elements
    $('.feature-card, .step-card').hover(
        function() {
            $(this).css('transform', 'translateY(-10px) scale(1.02)');
        },
        function() {
            $(this).css('transform', 'translateY(0) scale(1)');
        }
    );

    // Typing effect for hero subtitle
    function typeWriter(element, text, speed) {
        speed = speed || 50;
        var i = 0;
        element.html('');

        function type() {
            if (i < text.length) {
                element.html(element.html() + text.charAt(i));
                i++;
                setTimeout(type, speed);
            }
        }
        type();
    }

    // Initialize typing effect after page load
    $(window).on('load', function() {
        var subtitle = $('.hero-content .subtitle');
        if (subtitle.length) {
            var originalText = subtitle.text();
            setTimeout(function() {
                typeWriter(subtitle, originalText, 80);
            }, 1000);
        }
    });

    // Add floating animation to hero visual elements
    $('.hero-visual div[style*="position: absolute"]').each(function(index) {
        $(this).css('animation', 'float ' + (3 + index) + 's ease-in-out infinite ' + (index * 0.5) + 's');
    });

    // Intersection Observer for counting animations (if you want to add counters later)
    function animateValue(element, start, end, duration) {
        var startTimestamp = null;
        var step = function(timestamp) {
            if (!startTimestamp) startTimestamp = timestamp;
            var progress = Math.min((timestamp - startTimestamp) / duration, 1);
            element.html(Math.floor(progress * (end - start) + start));
            if (progress < 1) {
                window.requestAnimationFrame(step);
            }
        };
        window.requestAnimationFrame(step);
    }

    // Easter egg - konami code
    var konamiCode = [];
    var konamiSequence = [38, 38, 40, 40, 37, 39, 37, 39, 66, 65];

    $(document).keydown(function(e) {
        konamiCode.push(e.keyCode);
        if (konamiCode.length > konamiSequence.length) {
            konamiCode.shift();
        }

        if (konamiCode.toString() === konamiSequence.toString()) {
            // Easter egg activated!
            $('body').css('animation', 'rainbow 2s ease-in-out');
            setTimeout(function() {
                $('body').css('animation', '');
            }, 2000);
        }
    });

    // Add rainbow animation for easter egg
    $('<style>').text(`
        @keyframes rainbow {
            0% { filter: hue-rotate(0deg); }
            25% { filter: hue-rotate(90deg); }
            50% { filter: hue-rotate(180deg); }
            75% { filter: hue-rotate(270deg); }
            100% { filter: hue-rotate(360deg); }
        }
    `).appendTo('head');

    // Contact Form 7 success handling (if using CF7)
    document.addEventListener('wpcf7mailsent', function(event) {
        // Handle successful form submission
        alert('Thank you for your interest! We\'ll be in touch soon.');
    }, false);

    // Contact Form 7 error handling
    document.addEventListener('wpcf7mailfailed', function(event) {
        // Handle form submission error
        alert('Sorry, there was an error sending your message. Please try again.');
    }, false);

    // Custom WooCommerce Add to Cart with Sibling Popup
    var selectedProductId, selectedVariationId;

    // Handle main pricing Buy Now button click
    $('#pricing-buy-now').on('click', function(e) {
        e.preventDefault();
        $('#pricing-selection-modal').fadeIn(300);
    });

    // Handle pricing option selection
    $('.pricing-option').on('click', function() {
        $('.pricing-option').removeClass('selected');
        $(this).addClass('selected');
    });

    // Handle select option button clicks
    $('.select-option').on('click', function(e) {
        e.preventDefault();
        var $option = $(this).closest('.pricing-option');
        var productId = $option.data('product-id') || 164;
        var variationId = $option.data('variation-id');
        var price = $option.data('price');
        var name = $option.data('name');

        if (!variationId && !name) return;

        // Store selection for later use
        selectedProductId = productId;
        selectedVariationId = variationId;

        // Close pricing modal
        $('#pricing-selection-modal').fadeOut(300);

        // Show sibling popup after a brief delay
        setTimeout(function() {
            $('#sibling-popup').fadeIn(300);
        }, 400);
    });

    // Close pricing modal
    $('#close-pricing-modal, .pricing-selection-overlay').on('click', function() {
        $('#pricing-selection-modal').fadeOut(300);
    });





    // Debug: Log remove buttons on checkout (after DOM updates)
    function checkRemoveButtons() {
        if ($('body').hasClass('checkout-page')) {
            console.log('Checkout page detected');
            console.log('Template remove buttons found:', $('.remove-from-checkout').not('.manual-remove').length);
            console.log('Manual remove buttons found:', $('.manual-remove').length);
            console.log('Total remove buttons found:', $('.remove-from-checkout').length);
            $('.remove-from-checkout').each(function(index) {
                console.log('Button ' + index + ' cart_item_key:', $(this).data('cart_item_key'), 'manual:', $(this).hasClass('manual-remove'));
            });
        }
    }

    // Check initially and after checkout updates
    setTimeout(checkRemoveButtons, 500); // Give time for manual buttons to be added
    $('body').on('updated_checkout', function() {
        setTimeout(checkRemoveButtons, 500);
    });

    // Checkout: Remove item functionality
    $(document).on('click', '.remove-from-checkout', function(e) {
        e.preventDefault();
        console.log('Remove button clicked');

        var $this = $(this);
        var cartItemKey = $this.data('cart_item_key');
        console.log('Cart item key:', cartItemKey);

        if (!cartItemKey) {
            console.log('No cart item key found');
            alert('Error: Could not find item to remove');
            return;
        }

        // Confirm removal
        if (!confirm('Are you sure you want to remove this item from your cart?')) {
            return;
        }

        // Add loading state (works for both classic and blocks)
        if ($this.hasClass('block-remove')) {
            $this.closest('.wc-block-components-order-summary-item').addClass('removing-item');
        } else {
            $this.closest('tr').addClass('removing-item');
        }

        $.ajax({
            url: wc_add_to_cart_params.ajax_url,
            type: 'POST',
            data: {
                action: 'remove_cart_item',
                cart_item_key: cartItemKey,
                nonce: wc_add_to_cart_params.wc_ajax_nonce
            },
            success: function(response) {
                console.log('Remove response:', response);
                if (response.success) {
                    // Update cart fragments if they exist
                    if (response.data && response.data.fragments) {
                        $.each(response.data.fragments, function(key, value) {
                            $(key).replaceWith(value);
                        });
                    }

                    // Handle different checkout types
                    if ($('.wc-block-checkout').length > 0) {
                        // WooCommerce blocks - trigger a page refresh for now
                        setTimeout(function() {
                            window.location.reload();
                        }, 500);
                    } else {
                        // Classic checkout - trigger update
                        $('body').trigger('update_checkout');

                        // If no items left, redirect to cart or shop
                        if (response.data && response.data.cart_count === 0) {
                            setTimeout(function() {
                                window.location.href = wc_add_to_cart_params.cart_url || '/cart';
                            }, 1000);
                        }
                    }
                } else {
                    alert('Error removing item from cart: ' + (response.data ? response.data.message : ''));
                    if ($this.hasClass('block-remove')) {
                        $this.closest('.wc-block-components-order-summary-item').removeClass('removing-item');
                    } else {
                        $this.closest('tr').removeClass('removing-item');
                    }
                }
            },
            error: function(xhr, status, error) {
                console.log('AJAX error:', xhr.responseText);
                alert('Error removing item from cart');
                if ($this.hasClass('block-remove')) {
                    $this.closest('.wc-block-components-order-summary-item').removeClass('removing-item');
                } else {
                    $this.closest('tr').removeClass('removing-item');
                }
            }
        });
    });

    // Simple Modal System
    function openModal() {
        $('#lhs-modal').addClass('show');
        $('#modal-step-1').show();
        $('#modal-step-2').hide();
        $('body').css('overflow', 'hidden');
    }

    function closeModal() {
        $('#lhs-modal').removeClass('show');
        $('body').css('overflow', '');
    }

    // All buy now buttons trigger the modal
    $('#buy-now-btn, #hero-buy-now, .pricing-buy-now, #pricing-buy-now, #footer-buy-now').on('click', function(e) {
        e.preventDefault();
        openModal();
    });

    // Menu dropdown triggers direct category selection
    $('#packages-menu-trigger').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('.dropdown-menu').removeClass('mobile-open'); // Close mobile dropdown

        // Close mobile menu if in mobile menu
        var navLinks = $('.nav-links');
        var mobileMenu = $('.mobile-menu');
        if (navLinks.hasClass('active')) {
            navLinks.removeClass('active');
            mobileMenu.removeClass('active');
            $('body').css('overflow', '');
        }

        openModal();
        showCategoryProducts('packages');
    });

    $('#subscriptions-menu-trigger').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('.dropdown-menu').removeClass('mobile-open'); // Close mobile dropdown

        // Close mobile menu if in mobile menu
        var navLinks = $('.nav-links');
        var mobileMenu = $('.mobile-menu');
        if (navLinks.hasClass('active')) {
            navLinks.removeClass('active');
            mobileMenu.removeClass('active');
            $('body').css('overflow', '');
        }

        openModal();
        showCategoryProducts('subscriptions');
    });

    $('#events-menu-trigger').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('.dropdown-menu').removeClass('mobile-open'); // Close mobile dropdown

        // Close mobile menu if in mobile menu
        var navLinks = $('.nav-links');
        var mobileMenu = $('.mobile-menu');
        if (navLinks.hasClass('active')) {
            navLinks.removeClass('active');
            mobileMenu.removeClass('active');
            $('body').css('overflow', '');
        }

        openModal();
        showCategoryProducts('events');
    });

    // Table row clicks also trigger category selection
    $('.clickable-row').on('click', function(e) {
        e.preventDefault();
        if ($(this).hasClass('sibling-info-row')) return;

        var category = $(this).data('category');
        openModal();
        showCategoryProducts(category);
    });

    // Category selection in step 1
    $('.lhs-category-option').on('click', function() {
        var category = $(this).data('category');
        showCategoryProducts(category);
    });

    // Back button
    $('.lhs-back-btn').on('click', function() {
        $('#modal-step-2').hide();
        $('#modal-step-1').show();
    });

    // Close modal
    $('.lhs-modal-close, .lhs-modal-overlay').on('click', function() {
        closeModal();
    });

    // Close modal when clicking outside of modal content
    $('#lhs-modal').on('click', function(e) {
        if (e.target === this) {
            closeModal();
        }
    });

    // Close modal with Escape key
    $(document).on('keydown', function(e) {
        if (e.key === 'Escape' && $('#lhs-modal').hasClass('show')) {
            closeModal();
        }
    });

    // Mobile dropdown functionality
    function isMobile() {
        return window.innerWidth <= 640;
    }

    // Handle dropdown clicks for both desktop and mobile
    $('.dropdown > a').on('click touchstart', function(e) {
        var dropdown = $(this).parent();
        var dropdownMenu = dropdown.find('.dropdown-menu');
        var isInMobileMenu = $(this).closest('.nav-links').length > 0;

        if (isMobile() || isInMobileMenu) {
            // Mobile or mobile menu: Toggle dropdown
            e.preventDefault();
            e.stopPropagation();

            // Close other dropdowns
            $('.dropdown').not(dropdown).find('.dropdown-menu').removeClass('mobile-open');

            // Toggle this dropdown
            dropdownMenu.toggleClass('mobile-open');
        } else {
            // Desktop: Prevent navigation to #pricing, let hover handle the dropdown
            if ($(this).hasClass('pricing-dropdown-link')) {
                e.preventDefault();
            }
        }
    });

    // Close mobile dropdowns when clicking outside
    $(document).on('click', function(e) {
        if (isMobile() && !$(e.target).closest('.dropdown').length) {
            $('.dropdown-menu').removeClass('mobile-open');
        }
    });

    // Handle window resize to clean up mobile dropdown states
    $(window).on('resize', function() {
        if (!isMobile()) {
            $('.dropdown-menu').removeClass('mobile-open');
        }
    });

    function showCategoryProducts(category) {
        $('#modal-step-1').hide();
        $('#modal-step-2').show();

        // Show loading
        $('#lhs-product-options').html('<div style="text-align: center; padding: 2rem;"><p>Loading products...</p></div>');

        // Check if we have the AJAX parameters
        if (typeof wc_add_to_cart_params === 'undefined') {
            console.log('wc_add_to_cart_params is undefined, using fallback');
            showFallbackProducts(category);
            return;
        }

        console.log('Using AJAX URL:', wc_add_to_cart_params.ajax_url);
        console.log('Using nonce:', wc_add_to_cart_params.lhs_products_nonce);

        // Use AJAX to get real product data
        $.ajax({
            url: wc_add_to_cart_params.ajax_url,
            type: 'POST',
            data: {
                action: 'get_lhs_category_products',
                category: category,
                nonce: wc_add_to_cart_params.lhs_products_nonce
            },
            success: function(response) {
                console.log('AJAX Response:', response);
                if (response.success && response.data && response.data.html) {
                    $('#lhs-product-options').html(response.data.html);
                } else {
                    console.log('AJAX failed or no data, using fallback. Error:', response.data ? response.data.message : 'Unknown error');
                    showFallbackProducts(category);
                }
            },
            error: function(xhr, status, error) {
                console.log('AJAX Error:', status, error, xhr.responseText);
                showFallbackProducts(category);
            }
        });
    }

    function showFallbackProducts(category) {
        var productOptions = '';

        if (category === 'packages') {
            productOptions = `
                <div class="lhs-product-option" data-product-id="164" data-price="24.95">
                    <h3>1 Project Box</h3>
                    <div class="price">$24.95</div>
                    <p>Perfect for gifting and random rainy days</p>
                    <button class="lhs-add-to-cart">Add to Cart</button>
                </div>
                <div class="lhs-product-option" data-product-id="164" data-price="58.95">
                    <h3>3 Project Boxes</h3>
                    <div class="price">$58.95</div>
                    <p>Great for regular family art time</p>
                    <button class="lhs-add-to-cart">Add to Cart</button>
                </div>
                <div class="lhs-product-option" data-product-id="164" data-price="84.95">
                    <h3>5 Project Boxes</h3>
                    <div class="price">$84.95</div>
                    <p>Best value for creative families</p>
                    <button class="lhs-add-to-cart">Add to Cart</button>
                </div>
            `;
        } else if (category === 'subscriptions') {
            productOptions = `
                <div class="lhs-product-option" data-product-id="190" data-price="60.00">
                    <h3>Monthly Subscription</h3>
                    <div class="price">$60.00/month</div>
                    <p>Automatic monthly art box deliveries</p>
                    <button class="lhs-add-to-cart">Subscribe</button>
                </div>
            `;
        } else if (category === 'events') {
            productOptions = `
                <div class="lhs-product-option" data-product-id="195" data-price="100.00">
                    <h3>Event Package</h3>
                    <div class="price">$100.00</div>
                    <p>Special occasion art experiences</p>
                    <button class="lhs-add-to-cart">Book Event</button>
                </div>
            `;
        }

        $('#lhs-product-options').html(productOptions);
    }

    // Store selected product data for sibling popup
    var selectedProduct = null;

    // Add to cart functionality
    $(document).on('click', '.lhs-add-to-cart', function() {
        var $option = $(this).closest('.lhs-product-option');
        var productId = $option.data('product-id');
        var variationId = $option.data('variation-id');
        var price = $option.data('price');
        var productName = $option.find('h3').text();

        // Store the selected product data
        selectedProduct = {
            productId: productId,
            variationId: variationId,
            price: price,
            name: productName
        };

        // Show the sibling addon popup
        showSiblingPopup();
    });

    // Function to show sibling popup
    function showSiblingPopup() {
        $('#sibling-popup').show();
        $('body').css('overflow', 'hidden');
    }

    // Function to hide sibling popup
    function hideSiblingPopup() {
        $('#sibling-popup').hide();
        $('body').css('overflow', '');
    }

    // Handle sibling addon decision
    $('#add-sibling').on('click', function() {
        if (selectedProduct) {
            addToCartWithSibling(selectedProduct);
        }
        hideSiblingPopup();
    });

    $('#skip-sibling').on('click', function() {
        if (selectedProduct) {
            addToCartWithoutSibling(selectedProduct);
        }
        hideSiblingPopup();
    });

    // Close sibling popup when clicking overlay
    $('.sibling-popup-overlay').on('click', function() {
        hideSiblingPopup();
    });

    // Function to add product to cart with sibling addon
    function addToCartWithSibling(product) {
        // Show loading state
        showLoadingState();

        var data = {
            action: 'lhs_add_to_cart_with_sibling',
            product_id: product.productId,
            variation_id: product.variationId || '',
            nonce: wc_add_to_cart_params.wc_ajax_nonce
        };

        $.ajax({
            url: wc_add_to_cart_params.ajax_url,
            type: 'POST',
            data: data,
            success: function(response) {
                console.log('Add to cart with sibling response:', response);
                if (response.success) {
                    // Close the main modal
                    closeModal();
                    // Redirect to checkout
                    window.location.href = response.data.checkout_url || '/checkout/';
                } else {
                    alert('Error adding to cart: ' + (response.data.message || 'Unknown error'));
                }
                hideLoadingState();
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', error);
                alert('Error adding to cart. Please try again.');
                hideLoadingState();
            }
        });
    }

    // Function to add product to cart without sibling addon
    function addToCartWithoutSibling(product) {
        // Show loading state
        showLoadingState();

        var data = {
            action: 'lhs_add_to_cart_single',
            product_id: product.productId,
            variation_id: product.variationId || '',
            nonce: wc_add_to_cart_params.wc_ajax_nonce
        };

        $.ajax({
            url: wc_add_to_cart_params.ajax_url,
            type: 'POST',
            data: data,
            success: function(response) {
                console.log('Add to cart single response:', response);
                if (response.success) {
                    // Close the main modal
                    closeModal();
                    // Redirect to checkout
                    window.location.href = response.data.checkout_url || '/checkout/';
                } else {
                    alert('Error adding to cart: ' + (response.data.message || 'Unknown error'));
                }
                hideLoadingState();
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', error);
                alert('Error adding to cart. Please try again.');
                hideLoadingState();
            }
        });
    }

    // Loading state functions
    function showLoadingState() {
        $('#add-sibling, #skip-sibling').prop('disabled', true).text('Processing...');
    }

    function hideLoadingState() {
        $('#add-sibling').prop('disabled', false).text('Yes, Add Sibling Kit');
        $('#skip-sibling').prop('disabled', false).text('No Thanks');
    }

    // Checkout sibling upsell functionality
    $('.add-sibling-checkout').on('click', function() {
        var $button = $(this);
        var productId = $button.data('product-id');

        $button.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Adding...');

        $.ajax({
            url: little_hands_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'add_sibling_checkout',
                product_id: productId,
                nonce: little_hands_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Hide the upsell
                    $('.checkout-sibling-upsell').slideUp(300);

                    // Trigger checkout update
                    $('body').trigger('update_checkout');

                    // Update cart count if header cart exists
                    if (response.data.cart_count) {
                        $('.cart-count').text(response.data.cart_count);
                    }
                } else {
                    alert(response.data.message || 'Failed to add sibling kit');
                    $button.prop('disabled', false).html('<i class="fas fa-plus"></i> Add to Order');
                }
            },
            error: function() {
                alert('Error adding sibling kit to cart');
                $button.prop('disabled', false).html('<i class="fas fa-plus"></i> Add to Order');
            }
        });
    });

    // Dismiss sibling upsell
    $('.dismiss-sibling-upsell').on('click', function() {
        $('.checkout-sibling-upsell').slideUp(300);
    });

    // Intro Popup for First-Time Customers
    function showIntroPopup() {
        // Check if user has seen the popup before
        if (!localStorage.getItem('lhs_intro_popup_shown')) {
            setTimeout(function() {
                $('#intro-popup').addClass('show');
                $('body').css('overflow', 'hidden');
            }, 2000); // Show after 2 seconds
        }
    }

    // Close intro popup
    $('#close-intro-popup, .intro-popup-overlay').on('click', function() {
        $('#intro-popup').removeClass('show');
        $('body').css('overflow', '');
        localStorage.setItem('lhs_intro_popup_shown', 'true');
    });

    // Intro popup buy now button
    $('#intro-buy-now').on('click', function(e) {
        e.preventDefault();
        // Close intro popup and show buy now modal
        $('#intro-popup').removeClass('show');
        localStorage.setItem('lhs_intro_popup_shown', 'true');
        setTimeout(function() {
            selectedCategory = 'all';
            showBuyNowModal();
        }, 400);
    });

    // Show intro popup on page load
    $(window).on('load', function() {
        showIntroPopup();
    });

    // Category card button handlers
    $('.category-cta-btn').on('click', function(e) {
        e.preventDefault();
        selectedCategory = $(this).data('category');
        showBuyNowModal();
    });



    // Hide "New in store" section on Cart page
    function hideNewInStoreSection() {
        // Look for headings containing "New in store"
        $('h1, h2, h3, h4, h5, h6').each(function() {
            if ($(this).text().trim().toLowerCase().includes('new in store')) {
                $(this).hide();
                // Also hide the next element which is likely the products block
                $(this).next().hide();
                // Hide any product blocks specifically
                $(this).siblings('.wp-block-woocommerce-product-new').hide();
            }
        });

        // Direct targeting of product blocks
        $('.wp-block-woocommerce-product-new').hide();
    }

    // Run on page load
    hideNewInStoreSection();

    // Run when content changes (for AJAX/dynamic content)
    var cartObserver = new MutationObserver(function(mutations) {
        hideNewInStoreSection();
    });

    // Observe cart and checkout containers
    if ($('.wc-block-cart').length || $('.woocommerce-cart').length) {
        cartObserver.observe(document.body, {
            childList: true,
            subtree: true
        });
    }

});