<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}
?>

<div class="little-hands-checkout-wrapper">
    <div class="checkout-header">
        <div class="container">
            <div class="checkout-logo">
                <a href="<?php echo home_url('/'); ?>" title="Return to Home">
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo.png" alt="Little Hands Studio" height="60">
                </a>
            </div>
            <div class="checkout-info">
                <div class="checkout-steps">
                    <span class="step active">Checkout</span>
                    <span class="step-divider">→</span>
                    <span class="step">Payment</span>
                    <span class="step-divider">→</span>
                    <span class="step">Confirmation</span>
                </div>
                <?php if (WC()->cart->get_cart_contents_count() > 0) : ?>
                <div class="checkout-cart-icon">
                    <i class="fas fa-shopping-cart"></i>
                    <span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="container checkout-container">
        <form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

            <div class="checkout-main-content">
                <div class="checkout-form-section">

                    <?php if ( $checkout->get_checkout_fields() ) : ?>

                        <?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

                        <div class="checkout-customer-details">

                            <div class="checkout-billing">
                                <h3><i class="fas fa-user"></i> Contact & Billing Information</h3>
                                <?php do_action( 'woocommerce_checkout_billing' ); ?>
                            </div>

                            <div class="checkout-shipping">
                                <?php do_action( 'woocommerce_checkout_shipping' ); ?>
                            </div>

                        </div>

                        <?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

                    <?php endif; ?>

                    <?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>

                    <div class="checkout-payment-section">
                        <h3><i class="fas fa-credit-card"></i> Payment Method</h3>
                        <?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
                        <div id="payment" class="woocommerce-checkout-payment">
                            <?php woocommerce_checkout_payment(); ?>
                        </div>
                    </div>

                </div>

                <div class="checkout-order-review">
                    <div class="order-review-sticky">
                        <h3><i class="fas fa-shopping-bag"></i> Your Order</h3>
                        <div id="order_review" class="woocommerce-checkout-review-order">
                            <?php woocommerce_order_review(); ?>
                        </div>
                    </div>
                </div>
            </div>

        </form>
    </div>
</div>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>