<?php
/**
 * Front Page Template for Little Hands Studio
 */

get_header();
?>


<div class="scroll-indicator">
    <div class="scroll-progress"></div>
</div>

<!-- Hero Section -->
<section class="hero" id="home">
    <div class="floating-elements">
        <div class="decorative-pattern" style="top: 10%; left: 5%;">🌙</div>
        <div class="decorative-pattern" style="top: 20%; right: 10%;">⭐</div>
        <div class="decorative-pattern" style="bottom: 30%; left: 15%;">🌸</div>
        <div class="decorative-pattern" style="bottom: 20%; right: 20%;">✨</div>
        <div class="decorative-pattern" style="top: 60%; left: 8%;">🎨</div>
        <div class="decorative-pattern" style="top: 80%; right: 15%;">🖌️</div>
    </div>

    <div class="hero-container">
        <div class="hero-content">
            <h1><?php echo esc_html(get_field('hero_title') ?: 'Unbox Creativity!'); ?></h1>
            <p class="subtitle"><?php echo esc_html(get_field('hero_subtitle') ?: 'Art Time, Parent-Approved!'); ?></p>
            <p class="description">
                <?php echo esc_html(get_field('hero_description') ?: 'Art Time, Parent-Approved! A subscription-based service for art projects tailored to parents and their young kids — convenience for busy parents and a steady stream of creative fun for the little ones.'); ?>
            </p>
            <div class="hero-buttons">
                <button class="btn-get-started hero-buy-now" id="hero-buy-now">
                    <i class="fas fa-shopping-cart"></i>
                    <?php echo esc_html(get_field('hero_cta_text') ?: 'Start Creating Today'); ?>
                </button>
            </div>
        </div>
        <div class="hero-visual">
            <div class="hero-box-container">
                <?php
                $hero_image = get_field('hero_image');
                if ($hero_image): ?>
                    <img src="<?php echo esc_url($hero_image['url']); ?>" alt="<?php echo esc_attr($hero_image['alt']); ?>" class="hero-box-image">
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>


<div class="section-divider"></div>

<!-- Promo Section -->
<section class="promo-section" id="promo">
    <div class="promo-container">
        <div class="promo-content">
            <div class="promo-visual">
                <?php
                $promo_image = get_field('promo_image');
                if ($promo_image): ?>
                    <img src="<?php echo esc_url($promo_image['url']); ?>" alt="<?php echo esc_attr($promo_image['alt']); ?>" class="promo-image">
                <?php endif; ?>
            </div>
            <div class="promo-text">
                <h2><?php echo esc_html(get_field('promo_title') ?: 'Art Adventures Delivered'); ?></h2>
                <p><?php echo esc_html(get_field('promo_description') ?: 'Every month brings new excitement with our carefully curated art boxes. From painting masterpieces to crafting keepsakes, each box contains 1-5 projects designed to inspire creativity and build confidence.'); ?></p>
                <div class="promo-highlights">
                    <div class="highlight-item">
                        <i class="<?php echo esc_attr(get_field('promo_highlight_1_icon') ?: 'fas fa-box'); ?>"></i>
                        <span><?php echo esc_html(get_field('promo_highlight_1_text') ?: 'Monthly themed boxes'); ?></span>
                    </div>
                    <div class="highlight-item">
                        <i class="<?php echo esc_attr(get_field('promo_highlight_2_icon') ?: 'fas fa-heart'); ?>"></i>
                        <span><?php echo esc_html(get_field('promo_highlight_2_text') ?: 'Age-appropriate projects'); ?></span>
                    </div>
                    <div class="highlight-item">
                        <i class="<?php echo esc_attr(get_field('promo_highlight_3_icon') ?: 'fas fa-shipping-fast'); ?>"></i>
                        <span><?php echo esc_html(get_field('promo_highlight_3_text') ?: '4-day turnaround + shipping'); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<div class="section-divider"></div>

<!-- Features Section -->
<section class="features" id="about">
    <div class="features-container">
        <div class="section-title reveal">
            <h2><?php echo esc_html(get_field('features_title') ?: 'Why Families Choose Little Hands Studio'); ?></h2>
            <p><?php echo esc_html(get_field('features_description') ?: 'We create magical moments through art, bringing families together with carefully crafted experiences that nurture creativity and connection.'); ?></p>
        </div>

        <div class="features-grid">
            <?php for ($i = 1; $i <= 6; $i++): ?>
            <div class="feature-card reveal">
                <i class="<?php echo esc_attr(get_field("feature_{$i}_icon") ?: 'fas fa-heart'); ?> feature-icon"></i>
                <h3><?php echo esc_html(get_field("feature_{$i}_title") ?: "Feature {$i}"); ?></h3>
                <p><?php echo nl2br(esc_html(get_field("feature_{$i}_description") ?: 'Description coming soon...')); ?></p>
            </div>
            <?php endfor; ?>
        </div>
    </div>
</section>

<div class="section-divider"></div>

<!-- Pricing Section -->
<section class="pricing" id="pricing">
    <div class="pricing-container">
        <div class="section-title reveal">
            <h2><?php echo esc_html(get_field('pricing_title') ?: 'Project Pricing'); ?></h2>
            <p><?php echo esc_html(get_field('pricing_description') ?: 'Choose the perfect plan for your little artist\'s creative journey'); ?></p>
        </div>

        <div class="pricing-table">
            <div class="pricing-table-wrapper">
                <table>
                    <thead>
                        <tr>
                            <th>Creative Options</th>
                            <th>Price</th>
                            <th>What's Included</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Get products for pricing display
                        $packages_product = wc_get_product(164);
                        $subscriptions_product = wc_get_product(190);
                        $events_product = wc_get_product(195);
                        $sibling_product = wc_get_product(169);

                        // Calculate "from" prices
                        $packages_price = 'Contact';
                        $packages_description = 'Monthly themed art boxes with all supplies included';

                        if ($packages_product && $packages_product->is_type('variable')) {
                            $variations = $packages_product->get_available_variations();
                            $prices = array_column($variations, 'display_price');
                            $packages_price = 'From $' . number_format(min($prices), 2);
                            $packages_description = $packages_product->get_short_description() ?: $packages_description;
                        }

                        $subscriptions_price = $subscriptions_product ? 'From $' . number_format($subscriptions_product->get_price(), 2) : 'Contact';
                        $subscriptions_description = $subscriptions_product ? ($subscriptions_product->get_short_description() ?: 'Automatic monthly deliveries for continuous creativity') : 'Automatic monthly deliveries for continuous creativity';

                        $events_price = $events_product ? 'From $' . number_format($events_product->get_price(), 2) : 'Contact';
                        $events_description = $events_product ? ($events_product->get_short_description() ?: 'Special occasion art experiences and celebrations') : 'Special occasion art experiences and celebrations';

                        $sibling_price = $sibling_product ? '+$' . number_format($sibling_product->get_price(), 2) : '+$8.95';
                        $sibling_description = $sibling_product ? ($sibling_product->get_description() ?: $sibling_product->get_short_description() ?: 'Each sibling add-on includes a full set of materials — no sharing required! That means twice the fun, without double the cost.') : 'Each sibling add-on includes a full set of materials — no sharing required! That means twice the fun, without double the cost.';
                        ?>

                        <tr class="pricing-row clickable-row" data-category="packages">
                            <td><strong>Packages</strong></td>
                            <td><strong><?php echo $packages_price; ?></strong></td>
                            <td><?php echo esc_html($packages_description); ?></td>
                        </tr>

                        <tr class="pricing-row clickable-row" data-category="subscriptions">
                            <td><strong>Subscriptions</strong></td>
                            <td><strong><?php echo $subscriptions_price; ?></strong></td>
                            <td><?php echo esc_html($subscriptions_description); ?></td>
                        </tr>

                        <tr class="pricing-row clickable-row" data-category="events">
                            <td><strong>Events</strong></td>
                            <td><strong><?php echo $events_price; ?></strong></td>
                            <td><?php echo esc_html($events_description); ?></td>
                        </tr>

                        <tr class="pricing-row sibling-info-row">
                            <td><strong>+ Sibling Add-on Kit</strong></td>
                            <td><strong><?php echo $sibling_price; ?></strong></td>
                            <td><?php echo esc_html($sibling_description); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

            <!-- Buy Now Button at bottom of pricing section -->
            <div class="pricing-cta">
                <button class="btn-primary pricing-buy-now" id="pricing-buy-now">
                    <i class="fas fa-shopping-cart"></i>
                    Buy Now
                </button>
            </div>
        </div>
    </div>


</section>

<div class="section-divider flip with-pattern"></div>

<!-- About Me Section -->
<section class="about-me" id="about-me">
    <div class="about-container">
        <div class="about-content">
            <h2>Meet Miss Sabrina</h2>
            <p>Hello, <br>My name is Miss Sabrina, and I am an art teacher originally from Switzerland.</p>

            <p>I relocated to Canada in 2016 and earned my bachelor of arts degree from Kwantlen Polytechnic University (KPU) in 2021. While I had always aspired to become a teacher, I decided to take a hiatus from formal education after graduation. During this period, I explored various career paths before joining an arts-focused musical theatre school seeking an after-school program developer. I was assigned to develop the art component of the program, teaching art five times per week.</p>

            <p>I soon discovered a profound passion for art, as it allowed me to express my creativity freely. Not only did I create a diverse range of projects, but I also incorporated art history into my lessons, engaging students in a playful and educational approach to renowned artists such as Monet and Van Gogh.</p>

            <p>Art possesses immense potential, yet it often remains underutilized due to limited time. This is the driving force behind my mission. I aim to alleviate the burden of project development for parents while providing engaging, educational, and enjoyable activities for both parents and their children.</p>
        </div>
    </div>
</section>

<div class="section-divider with-pattern"></div>

<!-- Contact Form Section -->
<section class="cta-section" id="contact">
    <div class="decorative-pattern" style="top: 10%; left: 10%; font-size: 3rem; opacity: 0.1;">🎨</div>
    <div class="decorative-pattern" style="bottom: 15%; right: 15%; font-size: 2.5rem; opacity: 0.1;">✨</div>

    <div class="cta-container">
        <h2><?php echo esc_html(get_field('waitlist_title') ?: 'Ready to Join Our Creative Journey?'); ?></h2>
        <p><?php echo esc_html(get_field('waitlist_description') ?: 'Express your interest in our art classes! We\'ll keep you updated on availability and upcoming sessions.'); ?></p>

        <?php echo do_shortcode('[contact-form-7 id="d133728" title="Untitled"]'); ?>

        <p style="margin-top: 2rem; opacity: 0.8; font-size: 0.9rem;">
            <?php echo esc_html(get_field('waitlist_note') ?: '🎨 Currently developing our art class program - join the waitlist for early access!'); ?>
        </p>
    </div>
</section>


<!-- Intro Popup -->
<div id="intro-popup" class="intro-popup" style="display: none;">
    <div class="intro-popup-overlay"></div>
    <div class="intro-popup-content">
        <button class="modal-close" id="close-intro-popup">&times;</button>
        <h2>Welcome to Little Hands Studio!</h2>
        <p class="offer-text">
            "That first moment of connection? Only $19. If you fall in love (and we think you might), keep the creativity coming for $24.95/month - always flexible, always joy-filled."
        </p>
        <div class="coupon-code">INTROLHS</div>
        <div class="intro-popup-buttons">
            <button class="btn-primary" id="intro-buy-now">Start Creating Today</button>
            <button class="btn-secondary" id="close-intro-popup">Maybe Later</button>
        </div>
    </div>
</div>

<?php get_footer(); ?>