<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<nav class="navbar">
    <div class="nav-container">
        <div class="logo">
            <a href="<?php echo home_url('/'); ?>" title="Little Hands Studio">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo.png" alt="Little Hands Studio Logo" class="main-logo">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/scrolllogo.png" alt="Little Hands Studio Logo" class="scroll-logo" style="display: none;">
            </a>
        </div>

        <ul class="nav-links">
            <li><a href="#home">Home</a></li>
            <li><a href="#about">Why Choose Us</a></li>
            <li class="dropdown">
                <a href="#pricing" class="pricing-dropdown-link">Pricing <i class="fas fa-chevron-down"></i></a>
                <ul class="dropdown-menu">
                    <li><a href="#" id="packages-menu-trigger">Packages</a></li>
                    <li><a href="#" id="subscriptions-menu-trigger">Subscriptions</a></li>
                    <li><a href="#" id="events-menu-trigger">Events</a></li>
                </ul>
            </li>
            <li><a href="#about-me">About Me</a></li>
            <li><a href="#" class="cta-button" id="buy-now-btn">Join Us</a></li>
            <?php if (class_exists('WooCommerce') && WC()->cart->get_cart_contents_count() > 0) : ?>
            <li>
                <a href="<?php echo wc_get_cart_url(); ?>" class="header-cart-icon" title="View Cart">
                    <i class="fas fa-shopping-cart"></i>
                    <span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                </a>
            </li>
            <?php endif; ?>
        </ul>

        <button class="mobile-menu">
            <i class="fas fa-bars"></i>
        </button>
    </div>
</nav>

<div id="page" class="site">