<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="woocommerce-order">

	<?php
	if ( $order ) :

		do_action( 'woocommerce_before_thankyou', $order->get_id() );
		?>

		<?php if ( $order->has_status( 'failed' ) ) : ?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'woocommerce' ); ?></a>
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'woocommerce' ); ?></a>
				<?php endif; ?>
			</p>

		<?php else : ?>

			<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', esc_html__( 'Thank you. Your order has been received.', 'woocommerce' ), $order ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>

			<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

				<li class="woocommerce-order-overview__order order">
					<?php esc_html_e( 'Order number:', 'woocommerce' ); ?>
					<strong><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
				</li>

				<li class="woocommerce-order-overview__date date">
					<?php esc_html_e( 'Date:', 'woocommerce' ); ?>
					<strong><?php echo wc_format_datetime( $order->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
				</li>

				<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) : ?>
					<li class="woocommerce-order-overview__email email">
						<?php esc_html_e( 'Email:', 'woocommerce' ); ?>
						<strong><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
					</li>
				<?php endif; ?>

				<li class="woocommerce-order-overview__total total">
					<?php esc_html_e( 'Total:', 'woocommerce' ); ?>
					<strong><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
				</li>

				<?php if ( $order->get_payment_method_title() ) : ?>
					<li class="woocommerce-order-overview__payment-method method">
						<?php esc_html_e( 'Payment method:', 'woocommerce' ); ?>
						<strong><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></strong>
					</li>
				<?php endif; ?>

			</ul>

			<!-- Custom E-Transfer Instructions -->
			<?php if (get_option('etransfer_enabled', 1)) : ?>
			<div class="etransfer-instructions">
				<h2>✅ Next Step: Send Your Interac E-Transfer</h2>

				<div class="etransfer-card">
					<div class="etransfer-section">
						<h3>📬 Send e-Transfer to:</h3>
						<div class="etransfer-detail">
							<strong>Recipient Email:</strong> <?php echo esc_html(get_option('etransfer_email', 'hello@littlehandsstudio.com')); ?>
						</div>
					</div>

					<div class="etransfer-section">
						<h3>💵 Amount to Send:</h3>
						<div class="etransfer-amount">
							<strong><?php echo $order->get_formatted_order_total(); ?></strong>
						</div>
					</div>

					<?php
					$question = get_option('etransfer_question', 'What is this for?');
					$answer = get_option('etransfer_answer', 'artbox');
					$notes = get_option('etransfer_notes', '(You can customize or remove this if auto-deposit is enabled)');
					if ($question && $answer) :
					?>
					<div class="etransfer-section">
						<h3>🧾 Security Question (if required):</h3>
						<div class="etransfer-detail">
							<strong>Question:</strong> <?php echo esc_html($question); ?><br>
							<strong>Answer:</strong> <?php echo esc_html($answer); ?><br>
							<?php if ($notes) : ?>
								<small><?php echo esc_html($notes); ?></small>
							<?php endif; ?>
						</div>
					</div>
					<?php endif; ?>

					<div class="etransfer-section">
						<h3>📝 Important Notes:</h3>
						<ul class="etransfer-notes">
							<li>Include your order number (<strong>#<?php echo $order->get_order_number(); ?></strong>) in the message or memo section of your transfer so we can match your payment.</li>
							<li>Your order will be processed once the e-Transfer is received.</li>
							<li>If you have auto-deposit enabled, no password is required.</li>
						</ul>
					</div>

					<div class="etransfer-section etransfer-timing">
						<h3>⏱️ When to Pay:</h3>
						<div class="etransfer-detail">
							Please send your e-Transfer within <strong><?php echo esc_html(get_option('etransfer_deadline', '24')); ?> hours</strong> to avoid delays in order processing.
						</div>
					</div>
				</div>
			</div>
			<?php endif; ?>

		<?php endif; ?>

		<?php do_action( 'woocommerce_thankyou_order_received_text', $order ); ?>

		<?php do_action( 'woocommerce_thankyou', $order->get_id() ); ?>

	<?php else : ?>

		<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', esc_html__( 'Thank you. Your order has been received.', 'woocommerce' ), null ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>

	<?php endif; ?>

</div>