<?php

/**
 * Enable HTML
 *
 * @package Bootscore 
 * @version 5.3.3
 */


// Exit if accessed directly
defined('ABSPATH') || exit;


/**
 * Enable HTML in terms (category, tag) descriptions
 */
foreach (array('pre_term_description') as $filter) {
  remove_filter($filter, 'wp_filter_kses');
  if (!current_user_can('unfiltered_html')) {
    add_filter($filter, 'wp_filter_post_kses');
  }
}

foreach (array('term_description') as $filter) {
  remove_filter($filter, 'wp_kses_data');
}


/**
 * Enable HTML in author bio
 */
remove_filter('pre_user_description', 'wp_filter_kses');
add_filter('pre_user_description', 'wp_filter_post_kses');
