jQuery(document).ready(function($) {
  function handleFormAnimation(form) {
    form.on('click', '.gform_next_button, .gform_previous_button', function(event) {
      event.preventDefault();
      event.stopPropagation();

      var currentPage = form.find('.gform_page:visible');
      var targetPageNumber = $(this).hasClass('gform_next_button') ? parseInt(currentPage.data('gf-page')) + 1 : parseInt(currentPage.data('gf-page')) - 1;
      var targetPage = form.find('.gform_page[data-gf-page="' + targetPageNumber + '"]');

      var animationSpeed = 400;
      var slideDistance = 600;

      if ($(this).hasClass('gform_next_button')) {
        animatePages(currentPage, targetPage, -slideDistance, animationSpeed);
      } else {
        animatePages(currentPage, targetPage, slideDistance, animationSpeed);
      }

      form.data('gf_page_current', targetPageNumber);
    });

    function animatePages(currentPage, targetPage, slideDistance, animationSpeed) {
      currentPage.animate({ left: slideDistance, opacity: 0 }, animationSpeed, function() {
        currentPage.css({ left: 0 }).hide();
      });

      targetPage.css({ left: -slideDistance, display: 'block', opacity: 0 }).animate({ left: 0, opacity: 1 }, animationSpeed);
    }

    function triggerButtonEvent(form, direction) {
      if (direction > 0) {
        form.find('.gform_previous_button:visible').trigger('click');
      } else {
        form.find('.gform_next_button:visible').trigger('click');
      }
    }

    form.find('.gform_page').draggable({
      axis: 'x',
      start: function(event, ui) {
        $(this).data('startX', ui.position.left);
      },
      stop: function(event, ui) {
        var currentPage = $(this);
        var direction = ui.position.left - $(this).data('startX');

        var threshold = 100; // Minimum distance required for a page change

        if (Math.abs(direction) >= threshold) {
          triggerButtonEvent(form, direction);
        } else {
          currentPage.animate({ left: 0 }, 400);
        }
      }
    });
  }

  $('.gform_wrapper form').each(function() {
    handleFormAnimation($(this));
  });

  $(document).on('gform_post_render', function(event, form_id, current_page) {
    var form = $('#gform_' + form_id);
    handleFormAnimation(form);
  });
});
