function handleFormAnimation(form) {
    form.on('click', '.gform_next_button, .gform_previous_button', function(event) {
      event.preventDefault();
      event.stopPropagation();

      var currentPage = form.find('.gform_page:visible');
      var targetPageNumber = $(this).hasClass('gform_next_button') ? parseInt(currentPage.data('gf-page')) + 1 : parseInt(currentPage.data('gf-page')) - 1;
      var targetPage = form.find('.gform_page[data-gf-page="' + targetPageNumber + '"]');
      var animationDuration = 400;

      // Calculate the direction of the sliding animation based on the target page number
      var direction = $(this).hasClass('gform_next_button') ? '-100%' : '100%';
      currentPage.animate({left: direction}, animationDuration, function() {
        currentPage.removeClass('gf_page_visible');
      });

      targetPage.css('left', direction === '100%' ? '-100%' : '100%');
      targetPage.addClass('gf_page_visible').animate({left: 0}, animationDuration);

      form.data('gf_page_current', targetPageNumber);
    });
}
