<?php
/**
 * Plugin Name: Gravity Forms Page Animations
 * Description: A plugin that provides animations for multi-page Gravity Forms.
 * Version: 1.0.0
 * Author: Your Name
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function gf_page_animations_enqueue_scripts() {
	if ( ! class_exists( 'GFForms' ) ) {
		return;
	}

	$css_path = plugin_dir_url( __FILE__ ) . 'animate.min.css';
	$js_path  = plugin_dir_url( __FILE__ ) . 'animations.js';

	wp_enqueue_style( 'animate', $css_path, array(), '1.0.0' );
	wp_enqueue_script( 'gf-page-animations', $js_path, array( 'jquery' ), '1.0.0', true );
}

add_action( 'wp_enqueue_scripts', 'gf_page_animations_enqueue_scripts' );


function enqueue_jquery_ui_effects() {
    wp_enqueue_script('jquery-ui-effects', 'https://code.jquery.com/ui/1.12.1/jquery-ui.min.js', array('jquery'), '1.12.1', true);
}
add_action('wp_enqueue_scripts', 'enqueue_jquery_ui_effects');



function my_custom_scripts() {
    wp_enqueue_script( 'hammer', 'https://cdnjs.cloudflare.com/ajax/libs/hammer.js/2.0.8/hammer.min.js', array('jquery'), '2.0.8', true );
}
add_action( 'wp_enqueue_scripts', 'my_custom_scripts' );
