<?php

GFForms::include_addon_framework();

class GFImgChoiceAddon extends GFAddOn {

	protected $_version = GF_PC_IMAGE_CHOICES_ADDON_VERSION;
	protected $_min_gravityforms_version = '1.9';
	protected $_slug = 'image-choices-for-gravity-forms';
	protected $_path = 'image-choices-for-gravity-forms/gf-img-choices.php';
	protected $_full_path = __FILE__;
	protected $_title = 'Image Choices For Gravity Forms';
	protected $_short_title = 'Image Choices GF';

	private static $_instance = null;

	/**
	 * Get an instance of this class.
	 *
	 * @return GFImgChoiceAddon
	 */
	public static function get_instance() {
		if ( self::$_instance == null ) {
			self::$_instance = new GFImgChoiceAddon();
		}

		return self::$_instance;
	}


	/**
	 * Handles hooks and loading of language files.
	 */
	public function init() {
		parent::init();

    	add_filter(	'gform_tooltips', array($this, 'gfic_add_tooltips'));
		add_action( 'gform_editor_js', array($this,'gfic_editor_script') );
		add_filter( 'gform_field_choice_markup_pre_render', array( $this, 'gfic_label_image_field'), 10, 4 );
		add_filter( 'gform_field_css_class', array( $this, 'gfic_custom_class' ), 10, 3 );
		if ( PC_IC_GF_MIN_2_5 ) {
			add_filter( 'gform_field_settings_tabs', array( $this, 'gfic_fields_settings_tab'), 10, 2 );
			add_action( 'gform_field_settings_tab_content_img_choice_tab', array($this, 'gfic_fields_settings_tab_content'), 10, 2 );
		} else {
			add_action('gform_field_advanced_settings', array($this, 'gfic_advanced_settings'), 10, 2);
		}
	}



    /**
	 * Return the scripts which should be enqueued.
	 *
	 * @return array
	 */
	public function scripts() {
		$scripts = array(
			array(
				'handle'  => 'gfic_admin_script',
				'src'     => $this->get_base_url() . '/assets/js/image-choice-end.js',
				'version' => time(),
				'deps'    => array( 'jquery' ),
				'enqueue'  => array(
						array( 'admin_page' => array( 'form_editor' ) ),
				)
			)
		);

		return array_merge( parent::scripts(), $scripts );
	}

	public function styles() {
		$styles = array(
			array(
				'handle'  => 'gfic_admin_style',
				'src'     => $this->get_base_url() . '/assets/css/gfic_admin_style.css',
				'version' => time(),
				'enqueue' => array(
					array( 'admin_page' => array( 'form_editor' ) ),
				)
			),
			array(
				'handle'  => 'gfic_front_style',
				'src'     => $this->get_base_url() . '/assets/css/gfic_front_style.css',
				'version' => time(),
				'enqueue' => array(
					array( 'field_types' => array( 'radio', 'checkbox' ) )
				)
			)
		);

		return array_merge( parent::styles(), $styles );
	}


	public function init_admin() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

		parent::init_admin();
	}

	public function admin_enqueue_scripts() {
		if ( $this->is_form_editor() ) {
			wp_enqueue_media();// For Media Library
		}
	}
	

	public function gfic_fields_settings_tab( $tabs, $form ) {
		$tabs[] = array(
			// Define the unique ID for your tab.
			'id'             => 'img_choice_tab',
			// Define the title to be displayed on the toggle button your tab.
			'title'          => 'Image Choices',
			// Define an array of classes to be added to the toggle button for your tab.
			'toggle_classes' => array( 'gfic_toggle_1', 'gfic_toggle_2' ),
			// Define an array of classes to be added to the body of your tab.
			'body_classes'   => array( 'gfic_toggle_class' ),
		);
	 
		return $tabs;
	}


    public function gfic_fields_settings_tab_content( $form) {
    	?>

        <li class="img_choice_field_setting field_setting">
            <ul>
                <li class="imgchoice_check">
                    <input type="checkbox" id="gfic_enable_imgchoice" onclick="SetFieldProperty('initImageGField', this.checked);" />
                    <label for="gfic_enable_imgchoice" class="inline">
                        <?php _e("Enable Image Choices Options", "gravityforms"); ?> 
                        <?php gform_tooltip("enable_image_choices"); ?>
                    </label>
                </li>
            </ul>
        </li>


    	<?php
    }


    public function gfic_advanced_settings( $position, $form_id ) {
		if ( $position == 550 ) {
		    $this->gfic_fields_settings_tab_content( GFAPI::get_form( $form_id ) );
		}
	}

	public function gfic_label_image_field( $choice_markup, $choice, $field, $value ) {

		if (  property_exists($field, 'initImageGField') && $field->initImageGField ) {
			
			$img = (isset($choice['imageUrl'])) ? $choice['imageUrl'] : '';
			$imgID = (isset($choice['imageId'])) ? $choice['imageId'] : '';

			if($img) {
				$img_markup = "<img width='100px' src=". $img ." />";
			} else {
				$img_markup = "";
			}
		
			return str_replace( "</label>", $img_markup ."</label>", $choice_markup );
		}

		return $choice_markup;
	}

	function gfic_custom_class( $classes, $field, $form ) {

		if ( $field->initImageGField === true && $field->type == 'radio' || $field->initImageGField === true && $field->type == 'checkbox') {
			$classes .= ' pc_image_choice';
		}
		return $classes;
	}

    function gfic_editor_script() {
        ?>

		<script type='text/javascript'>
	        //adding setting to fields of type "date"
	        
	        fieldSettings.radio += ", .img_choice_field_setting";
	        fieldSettings.checkbox += ", .img_choice_field_setting";
			
	        //binding to the load field settings event to initialize the checkbox
	        
	       	jQuery(document).bind("gform_load_field_settings", function(event, field, form){
                jQuery("#gfic_enable_imgchoice").prop( 'checked', Boolean( rgar( field, 'initImageGField' ) ) );
	        });

			jQuery('.choices_setting')
                .on('input propertychange', '.field-choice-image-id', function () {
                    var $this = jQuery(this);
                    var i = $this.closest('li.field-choice-row').data('index');
 
                    field = GetSelectedField();
                    field.choices[i].imageId= $this.val();
                });
			jQuery('.choices_setting')
					.on('input propertychange', '.field-choice-image-url', function () {
						var $this = jQuery(this);
						var i = $this.closest('li.field-choice-row').data('index');
	
						field = GetSelectedField();
						field.choices[i].imageUrl = $this.val();
					});
			gform.addFilter('gform_append_field_choice_option', function (str, field, i) {
				var inputType = GetInputType(field);
				var imageId = field.choices[i].imageId? field.choices[i].imageId: '';
				var imageurl = field.choices[i].imageUrl ? field.choices[i].imageUrl : '';
				if ( field['type'] === "radio" || field['type'] === "checkbox" ) {

					return "<input type='hidden' id='" + inputType + "_choice_image_id_" + i + "' value='" + imageId + "' class='field-choice-input field-choice-image-id' /><input type='hidden' id='" + inputType + "_choice_image_url_" + i + "' value='" + imageurl + "' class='field-choice-input field-choice-image-url' /><div class='show_hide_trigger'><button type='button' class='pc_image_media_upload'><i class='dashicons dashicons-format-image'></i></button><span class='image_preview_box' style='display:none'><span class='img_pick_preview'></span><span class='remove_pick_img'><i class='dashicons dashicons-no'></i></span></span></div>";
				}
	
				return "";
			});

	    </script>

	    <?php

    }


	public function gfic_add_tooltips() {
		$tooltips['enable_image_choices'] = esc_html__("Check this box to enable and show image choices options.", "gravityforms");

		return $tooltips;
	}

}



