<?php

add_action('cmb2_admin_init', 'zimed_cmb2_blog_page_metabox');
function zimed_cmb2_blog_page_metabox()
{

	$prefix = '_zimed_';

	$cmb = new_cmb2_box(array(
		'id'           => $prefix . 'blog_page_option',
		'title'        => __('Blog Page Option', 'zimed-core'),
		'object_types' => array('page'),
		'context'      => 'normal',
		'priority'     => 'default',
	));

	$cmb->add_field(array(
		'name' => __('Post Column Size', 'zimed-core'),
		'id' => $prefix . 'post_column_size',
		'type' => 'radio',
		'default' => '4',
		'options' => array(
			'12' => __('1 Columns', 'zimed-core'),
			'6' => __('2 Columns', 'zimed-core'),
			'4' => __('3 Columns', 'zimed-core'),
			'3' => __('4 Columns', 'zimed-core'),
			'2' => __('6 Columns', 'zimed-core'),
		),
	));
	$cmb->add_field(array(
		'name' => __('Show Sidebar', 'zimed-core'),
		'id' => $prefix . 'show_sidebar',
		'type' => 'radio',
		'default' => 'off',
		'options' => array(
			'on' => __('On', 'zimed-core'),
			'off' => __('Off', 'zimed-core'),
		),
	));
	$cmb->add_field(array(
		'name' => __('Sidebar Position', 'zimed-core'),
		'id' => $prefix . 'sidebar_position',
		'type' => 'radio',
		'default' => 'right_side',
		'options' => array(
			'right_side' => __('Right Side', 'zimed-core'),
			'left_side' => __('Left Side', 'zimed-core'),
		),
		'attributes' => array(
			'data-conditional-id' => $prefix . 'show_sidebar',
			'data-conditional-value' => 'on',
		),
	));
}

add_action('cmb2_admin_init', 'zimed_cmb2_add_page_metabox');
function zimed_cmb2_add_page_metabox()
{

	$prefix = 'zimed_';

	$cmb = new_cmb2_box(array(
		'id'           => $prefix . 'page_option',
		'title'        => __('Zimed Page Option', 'zimed-core'),
		'object_types' => array('page'),
		'context'      => 'normal',
		'priority'     => 'default',
	));

	$cmb->add_field(array(
		'name' => __('Navigation Menu type', 'zimed-core'),
		'id' => $prefix . 'menu_type',
		'type' => 'radio',
		'default' => 'primary_menu',
		'options' => array(
			'primary_menu' => __('Primary Menu', 'zimed-core'),
			'one_page_menu' => __('One Page Menu', 'zimed-core'),
		),
	));

	$cmb->add_field(array(
		'name' => __('Show Page Header', 'zimed-core'),
		'id' => $prefix . 'show_page_header',
		'type' => 'radio',
		'default' => 'on',
		'options' => array(
			'on' => __('On', 'zimed-core'),
			'off' => __('Off', 'zimed-core'),
		),
	));

	$cmb->add_field(array(
		'name' => __('Header Title', 'zimed-core'),
		'id' => $prefix . 'set_header_title',
		'type' => 'text',
		'attributes' => array(
			'data-conditional-id' => $prefix . 'show_page_header',
			'data-conditional-value' => 'on',
		),
	));

	$cmb->add_field(array(
		'name' => __('Header Image', 'zimed-core'),
		'id' => $prefix . 'set_header_image',
		'type' => 'file',
		'attributes' => array(
			'data-conditional-id' => $prefix . 'show_page_header',
			'data-conditional-value' => 'on',
		),
	));

	$cmb->add_field(array(
		'name' => __('Content Padding Top <small>(px/em value)</small>', 'zimed-core'),
		'id' => $prefix . 'page_content_padding_top',
		'type' => 'text',
	));

	$cmb->add_field(array(
		'name' => __('Content Padding Bottom <small>(px/em value)</small>', 'zimed-core'),
		'id' => $prefix . 'page_content_padding_bottom',
		'type' => 'text',
	));
}

add_action('cmb2_admin_init', 'zimed_cmb2_add_page_color_metabox');
function zimed_cmb2_add_page_color_metabox()
{

	$prefix = '_zimed_';

	$cmb = new_cmb2_box(array(
		'id'           => $prefix . 'page_color_options',
		'title'        => __('Page Color Options', 'zimed-core'),
		'object_types' => array('page'),
		'context'      => 'normal',
		'priority'     => 'default',
	));

	$cmb->add_field(array(
		'name' => __('Base Color', 'zimed-core'),
		'id' => $prefix . 'base_color',
		'type' => 'colorpicker',
		'default' => sanitize_hex_color('#ee464b'),
	));

	$cmb->add_field(array(
		'name' => __('Black Color', 'zimed-core'),
		'id' => $prefix . 'black_color',
		'type' => 'colorpicker',
		'default' => sanitize_hex_color('#272839'),
	));

	$cmb->add_field(array(
		'name' => __('Gray Color', 'zimed-core'),
		'id' => $prefix . 'gray_color',
		'type' => 'colorpicker',
		'default' => sanitize_hex_color('#f4f4f8'),
	));
}


add_action('cmb2_admin_init', 'zimed_cmb2_team_metabox');
function zimed_cmb2_team_metabox()
{

	$prefix = '_zimed_';

	$cmb = new_cmb2_box(array(
		'id'           => $prefix . 'team_options',
		'title'        => __('Team Options', 'zimed-core'),
		'object_types' => array('team'),
		'context'      => 'normal',
		'priority'     => 'default',
	));

	$cmb->add_field(array(
		'name' => __('Designation', 'zimed-core'),
		'id' => $prefix . 'designation',
		'type' => 'text',
	));

	$team_social = $cmb->add_field( array(
        'name' => __( 'Team Member Social Profiles', 'zimed-core'),
        'id' => $prefix . 'team_social',
        'type' => 'group',
    ) );

    $cmb->add_group_field( $team_social, array(
        'name' => __( 'icon', 'zimed-core'),
        'id' => $prefix . 'icon',
        'type' => 'select',
        'default' => 'fa-facebook-f',
        'options' => zimed_get_fa_icons(),
    ) );

    $cmb->add_group_field($team_social, array(
        'name' => __( 'link', 'zimed-core'),
        'id' => $prefix . 'link',
        'type' => 'text',
    ) );
}
