<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_CF7 extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-cf7';
    }

    public function get_title()
    {
        return __('Zimed - Contact Form', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-envelope';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'cf7_settings',
            [
                'label' => __('Contact Form Settings', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'select_wpcf7_form',
            [
                'label'       => esc_html__('Select your contact form 7', 'zimed-core'),
                'label_block' => true,
                'type'        => Controls_Manager::SELECT,
                'options'     => zimed_select_contact_form(),
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'contact_one_shapes',
            [
                'label' => __('Shapes Images', 'zimed-core')
            ]
        );
        $shape_images = new Repeater();

        $shape_images->add_control(
            'contact_one_shape_image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'contact_one_shape_images',
            [
                'label' => __('Image List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $shape_images->get_controls(),
                'title_field' => '{{{ contact_one_shape_image.id }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="contact-two">
            <?php $shapes_count = 1;
            foreach ($settings['contact_one_shape_images'] as $shape) {
                echo '<img src="' . $shape['contact_one_shape_image']['url'] . '" class="contact-two__shape-' . $shapes_count . '" alt="">';
                $shapes_count++;
            }
            ?>
            <div class="container">
                <div class="block-title text-center">
                    <span class="block-title__bubbles"></span>
                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                </div><!-- /.block-title -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="contact-one__form-wrap">
                            <?php echo do_shortcode('[contact-form-7 id="' . $settings['select_wpcf7_form'] . '" ]'); ?>
                        </div><!-- /.contact-one__form-wrap -->
                    </div><!-- /.col-lg-6 -->
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.contact-one -->

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_CF7());
