<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Contact_One extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-contact-one';
    }

    public function get_title()
    {
        return __('Zimed - Contact', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-address-card';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'contact_one_block',
            [
                'label' => __('Block Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'contact_one_form',
            [
                'label' => __('Select Contact Form', 'zimed-core')
            ]
        );

        $this->add_control(
            'contact_one_wpcf7',
            [
                'label'       => esc_html__('Select your contact form 7', 'zimed-core'),
                'label_block' => true,
                'type'        => Controls_Manager::SELECT,
                'options'     => zimed_select_contact_form(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'contact_one_gallery',
            [
                'label' => __('Gallery Images', 'zimed-core')
            ]
        );
        $gallery_images = new Repeater();

        $gallery_images->add_control(
            'contact_one_gallery_image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'contact_one_gallery_images',
            [
                'label' => __('Image List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $gallery_images->get_controls(),
                'title_field' => '{{{ contact_one_gallery_image.id }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'contact_one_infos',
            [
                'label' => __('Infos', 'zimed-core')
            ]
        );
        $infos_box = new Repeater();

        $infos_box->add_control(
            'contact_one_info_icon',
            [
                'label' => __('Add Icon', 'zimed-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => zimed_get_fa_icons(),
                'default' => 'zimed-icon-app-development',
            ]
        );
        $infos_box->add_control(
            'contact_one_info_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $infos_box->add_control(
            'contact_one_info_text',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'contact_one_infos_box',
            [
                'label' => __('Infos List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $infos_box->get_controls(),
                'title_field' => '{{{ contact_one_info_title.value }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'contact_one_shapes',
            [
                'label' => __('Shapes Images', 'zimed-core')
            ]
        );
        $shape_images = new Repeater();

        $shape_images->add_control(
            'contact_one_shape_image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'contact_one_shape_images',
            [
                'label' => __('Image List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $shape_images->get_controls(),
                'title_field' => '{{{ contact_one_shape_image.id }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <section class="contact-one">
            <?php $shapes_count = 1;
            foreach ($settings['contact_one_shape_images'] as $shape) {
                echo '<img src="' . $shape['contact_one_shape_image']['url'] . '" class="contact-one__shape-' . $shapes_count . '" alt="">';
                $shapes_count++;
            }
            ?>
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="contact-one__content">
                            <div class="contact-one__images">
                                <?php
                                foreach ($settings['contact_one_gallery_images'] as $gallery_image) {
                                    echo '<img src="' . $gallery_image['contact_one_gallery_image']['url'] . '" class="wow fadeInUp" data-wow-duration="1500ms" alt="">';
                                }
                                ?>
                            </div><!-- /.contact-one__images -->
                            <div class="contact-one__infos">
                                <?php
                                foreach ($settings['contact_one_infos_box'] as $info_box) : ?>
                                    <div class="contact-one__infos-single icon-box-wrapper">
                                        <div class="contact-one__infos-icon icon-box-with-bubble">
                                            <i class="<?php echo esc_attr($info_box['contact_one_info_icon']); ?>"></i>
                                        </div><!-- /.contact-one__infos-icon -->
                                        <div class="contact-one__infos-content">
                                            <h3><?php echo wp_kses($info_box['contact_one_info_title'], 'zimed_allowed_tags'); ?></h3>
                                            <p><?php echo wp_kses($info_box['contact_one_info_text'], 'zimed_allowed_tags'); ?></p>
                                        </div><!-- /.contact-one__infos-content -->
                                    </div><!-- /.contact-one__infos-single -->
                                <?php endforeach; ?>
                            </div><!-- /.contact-one__infos -->
                        </div><!-- /.contact-one__content -->
                    </div><!-- /.col-lg-6 -->
                    <div class="col-lg-6">
                        <div class="contact-one__form-wrap">
                            <div class="block-title color-5">
                                <span class="block-title__bubbles"></span>
                                <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                            </div><!-- /.block-title -->
                            <?php echo do_shortcode('[contact-form-7 id="' . $settings['contact_one_wpcf7'] . '" ]'); ?>
                        </div><!-- /.contact-one__form-wrap -->
                    </div><!-- /.col-lg-6 -->
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.contact-one -->
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Contact_One());
