<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Cta_One extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-cta-one';
    }

    public function get_title()
    {
        return __('Zimed - CTA One', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-bullhorn';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'cta_one_settings',
            [
                'label' => __('Settings', 'zimed-core')
            ]
        );


        $this->add_control(
            'block_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one'  => __('Style One', 'zimed-core'),
                    'two' => __('Style Two', 'zimed-core'),
                ],
                'default' => 'one',
            ]
        );

        $this->add_control(
            'cta_one_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'cta_one_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'cta_one_btn_label',
            [
                'label' => __('Btn Label', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'cta_one_btn_url',
            [
                'label' => __('Btn URL', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'section_image',
            [
                'label' => __('Section Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->end_controls_section();



        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

?>

        <?php if ('one' === $settings['block_type']) : ?>
            <section class="cta-one">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="cta-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="cta-one__circle-1"></div><!-- /.cta-one__circle-1 -->
                    <div class="cta-one__circle-2"></div><!-- /.cta-one__circle-2 -->
                    <div class="cta-one__circle-3"></div><!-- /.cta-one__circle-3 -->
                    <div class="cta-one__content text-center">
                        <h3><?php echo wp_kses($settings['cta_one_title'], 'zimed_allowed_tags'); ?> </h3>
                        <p><?php echo wp_kses($settings['cta_one_content'], 'zimed_allowed_tags'); ?> </p>
                        <a href="<?php echo esc_url($settings['cta_one_btn_url']); ?>" class="thm-btn cta-one__btn"><?php echo esc_html($settings['cta_one_btn_label']); ?></a><!-- /.thm-btn cta-one__btn -->

                    </div><!-- /.cta-one__content -->
                    <?php if (!empty($settings['section_image']['url'])) : ?>
                        <div class="cta-one__image-wrap text-center">
                            <img class="img-fluid" src="<?php echo esc_url($settings['section_image']['url']); ?>" alt="<?php echo wp_kses($settings['cta_one_title'], 'zimed_allowed_tags'); ?> ">
                        </div><!-- /.cta-one__image-wrap -->
                    <?php endif; ?>
                </div><!-- /.container -->
            </section><!-- /.cta-one -->
        <?php endif; ?>

        <?php if ('two' === $settings['block_type']) : ?>
            <section class="cta-one__style-two">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="cta-one__style-two__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="cta-one__style-two__content text-left">
                                <p><?php echo wp_kses($settings['cta_one_content'], 'zimed_allowed_tags'); ?> </p>
                                <h3><?php echo wp_kses($settings['cta_one_title'], 'zimed_allowed_tags'); ?> </h3>
                                <a href="<?php echo esc_url($settings['cta_one_btn_url']); ?>" class="thm-btn"><?php echo esc_html($settings['cta_one_btn_label']); ?></a><!-- /.thm-btn cta-one__btn -->
                            </div><!-- /.cta-one__content -->
                        </div><!-- /.col-lg-6 -->
                        <div class="col-lg-6">
                            <?php if (!empty($settings['section_image']['url'])) : ?>
                                <div class="cta-one__image-wrap clearfix">
                                    <img class="img-fluid" src="<?php echo esc_url($settings['section_image']['url']); ?>" alt="<?php echo esc_attr($settings['cta_one_title'], 'zimed_allowed_tags'); ?> ">
                                </div><!-- /.cta-one__image-wrap -->
                            <?php endif; ?>
                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.cta-one -->
        <?php endif; ?>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Cta_One());
