<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_FAQ extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-faq';
    }

    public function get_title()
    {
        return __('Zimed - FAQ', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-question';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout',
            [
                'label' => __('Select Layout', 'zimed-core')
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout_one'  => __('Style One', 'zimed-core'),
                    'layout_two'  => __('Style Two', 'zimed-core'),
                ],
                'default' => 'layout_one',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'block',
            [
                'label' => __('Block Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Tagline', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'block_summery',
            [
                'label' => __('Add Summery', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'section_image',
            [
                'label' => __('Add Section Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section('faq_content_section', [
            'label' => __('FAQ Content', 'zimed-core')
        ]);

        $repeater = new Repeater();

        $repeater->add_control(
            'faq_title',
            [
                'label' => __('Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('FAQ Title', 'zimed-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'faq_text',
            [
                'label' => __('Text', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('FAQ Text', 'zimed-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'expanded',
            [
                'label' => __('Is Expanded', 'zimed-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'your-plugin'),
                'label_off' => __('No', 'your-plugin'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'faq_content',
            [
                'label' => __('FAQ List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'faq_title' => __('Title #1', 'zimed-core'),
                        'faq_text' => __('FAQ Text', 'zimed-core'),
                        'expanded' => 'yes',
                    ],
                    [
                        'faq_title' => __('Title #2', 'zimed-core'),
                        'faq_text' => __('FAQ Text', 'zimed-core'),
                        'expanded' => 'no',
                    ],
                    [
                        'faq_title' => __('Title #3', 'zimed-core'),
                        'faq_text' => __('FAQ Text', 'zimed-core'),
                        'expanded' => 'no',
                    ],

                ],
                'title_field' => '{{{ faq_title }}}',
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <?php if ('layout_one' === $settings['layout_type']) : ?>
            <section class="faq-one faq-one__layout-two">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="faq-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <?php if (!empty($settings['block_title'])) : ?>
                        <div class="block-title text-center">
                            <span class="block-title__bubbles"></span>
                            <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                            <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                        </div><!-- /.block-title -->
                    <?php endif; ?>
                    <div class="accrodion-grp wow fadeIn faq-accrodion" data-grp-name="faq-accrodion-<?php echo esc_attr($this->get_id()); ?>">
                        <?php foreach ($settings['faq_content'] as $faq_content) : ?>
                            <?php $faq_content_active_class = ('yes' == $faq_content['expanded']) ? 'active' : ''; ?>
                            <div class="accrodion <?php echo esc_attr($faq_content_active_class); ?>">
                                <div class="accrodion-inner">
                                    <div class="accrodion-title">
                                        <h4><?php echo esc_html($faq_content['faq_title']); ?></h4>
                                    </div>
                                    <div class="accrodion-content">
                                        <div class="inner">
                                            <p><?php echo esc_html($faq_content['faq_text']); ?></p>
                                        </div><!-- /.inner -->
                                    </div>
                                </div><!-- /.accrodion-inner -->
                            </div>

                        <?php endforeach; ?>
                    </div>

                </div><!-- /.container -->
            </section><!-- /.faq-one -->
        <?php endif; ?>
        <?php if ('layout_two' === $settings['layout_type']) : ?>
            <section class="faq-one faq-one__layout-two">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="faq-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="faq-one__content">
                                <?php if (!empty($settings['block_title'])) : ?>
                                    <div class="block-title text-left color-2">
                                        <span class="block-title__bubbles"></span>
                                        <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                                        <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                                    </div><!-- /.block-title -->
                                <?php endif; ?>
                                <?php if (!empty($settings['block_summery'])) : ?>
                                    <p><?php echo wp_kses($settings['block_summery'], 'zimed_allowed_tags'); ?> </p>
                                <?php endif; ?>
                                <img src="<?php echo esc_url($settings['section_image']['url']); ?>" alt="" class="img-fluid">
                            </div><!-- /.faq-one__content -->
                        </div><!-- /.col-lg-5 -->
                        <div class="col-lg-7">
                            <div class="accrodion-grp wow fadeIn faq-accrodion" data-grp-name="faq-accrodion-<?php echo esc_attr($this->get_id()); ?>">
                                <?php foreach ($settings['faq_content'] as $faq_content) : ?>
                                    <?php $faq_content_active_class = ('yes' == $faq_content['expanded']) ? 'active' : ''; ?>
                                    <div class="accrodion <?php echo esc_attr($faq_content_active_class); ?>">
                                        <div class="accrodion-inner">
                                            <div class="accrodion-title">
                                                <h4><?php echo esc_html($faq_content['faq_title']); ?></h4>
                                            </div>
                                            <div class="accrodion-content">
                                                <div class="inner">
                                                    <p><?php echo esc_html($faq_content['faq_text']); ?></p>
                                                </div><!-- /.inner -->
                                            </div>
                                        </div><!-- /.accrodion-inner -->
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div><!-- /.col-lg-7 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.faq-one -->
        <?php endif; ?>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_FAQ());
