<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Feature extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-feature';
    }

    public function get_title()
    {
        return __('Zimed - Feature', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-grip-horizontal';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'feature_settings',
            [
                'label' => __('Settings', 'zimed-core')
            ]
        );



        $this->add_control(
            'floating_text',
            [
                'label' => __('Floated Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'section_image',
            [
                'label' => __('Add Section Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'zimed-core')
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => __('Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Tab Title', 'zimed-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_text',
            [
                'label' => __('Text', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Tab Content', 'zimed-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'expanded',
            [
                'label' => __('Is Active', 'zimed-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'your-plugin'),
                'label_off' => __('No', 'your-plugin'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'tab_content',
            [
                'label' => __('Tab List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => __('Title #1', 'zimed-core'),
                        'tab_text' => __('Tab Text', 'zimed-core'),
                        'expanded' => 'yes',
                    ],
                    [
                        'tab_title' => __('Title #2', 'zimed-core'),
                        'tab_text' => __('Tab Text', 'zimed-core'),
                        'expanded' => 'no',
                    ],
                    [
                        'tab_title' => __('Title #3', 'zimed-core'),
                        'tab_text' => __('Tab Text', 'zimed-core'),
                        'expanded' => 'no',
                    ],


                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="feature-one">
            <?php $bg_shapes_count = 1;
            foreach ($settings['bg_shapes'] as $bg_shape) {
                echo '<img src="' . $bg_shape['url'] . '" class="feature-one__shape-' . $bg_shapes_count . '" alt="">';
                $bg_shapes_count++;
            }
            ?>
            <h1 class="floated-text"><?php echo wp_kses($settings['floating_text'], 'zimed_allowed_tags'); ?> </h1>
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <img src="<?php echo esc_url($settings['section_image']['url']); ?>" alt="" class="feature-one__image">
                    </div><!-- /.col-lg-6 -->
                    <div class="col-lg-6">
                        <div class="feature-one__content">
                            <div class="block-title text-left color-5">
                                <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                                <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                            </div><!-- /.block-title -->
                            <ul class="list-unstyled feature-one__tab-title">
                                <?php foreach ($settings['tab_content'] as $tab_content) : ?>
                                    <?php $tab_content_active_class = ('yes' == $tab_content['expanded']) ? 'active' : ''; ?>
                                    <li class="<?php echo esc_attr($tab_content_active_class); ?>">
                                        <span><?php echo esc_html($tab_content['tab_title']); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul><!-- /.list-unstyled feature-one__tab-title -->
                            <?php foreach ($settings['tab_content'] as $tab_content) : ?>
                                <?php $tab_content_active_class = ('yes' == $tab_content['expanded']) ? 'active' : ''; ?>
                                <div class="feature-one__tab-content animated fadeIn <?php echo esc_attr($tab_content_active_class); ?>">
                                    <?php echo wp_kses($tab_content['tab_text'], 'zimed_allowed_tags'); ?>
                                </div><!-- /.feature-one__tab-content -->
                            <?php endforeach; ?>
                        </div><!-- /.feature-one__content -->
                    </div><!-- /.col-lg-6 -->
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Feature());
