<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Footer_About extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-footer-about';
    }

    public function get_title()
    {
        return __('Zimed - Footer About', 'zimed-core');
    }

    public function get_icon()
    {
        return 'eicon-section';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'about_settings',
            [
                'label' => __('Settings', 'zimed-core')
            ]
        );

        $this->add_control(
            'footer_logo',
            [
                'label' => __('Logo Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'footer_logo_width',
            [
                'label' => __('Logo Width', 'zimed-core'),
                'type' => Controls_Manager::NUMBER,
            ]
        );

        $this->add_control(
            'footer_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="footer-widget footer-widget__about">
            <a class="footer-widget__logo" href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_attr($settings['footer_logo']['url']); ?>" width="<?php echo esc_attr($settings['footer_logo_width']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" /></a>

            <?php echo wp_kses($settings['footer_content'], 'zimed_allowed_tags') ?>
        </div><!-- /.footer-widget -->
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Footer_About());
