<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Footer_MC extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-footer-mc';
    }

    public function get_title()
    {
        return __('Zimed - Footer MailChimp', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fab fa-mailchimp';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'mailchimp_settings',
            [
                'label' => __('Settings', 'zimed-core')
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Subscribe', 'zimed-core'),
            ]
        );

        $this->add_control(
            'mc_form_url',
            [
                'label' => __('Add Mailchimp Form URL', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'mc_input_placeholder',
            [
                'label' => __('Add Placeholder', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Email address', 'zimed-core'),
            ]
        );

        $this->add_control(
            'mc_btn_text',
            [
                'label' => __('Button Text', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Register Now', 'zimed-core'),
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="footer-widget footer-widget__subscribe">
            <h3 class="footer-widget__title"><?php echo esc_html($settings['title']); ?></h3>
            <form class="footer-widget__mc-form mc-form" data-url="<?php echo esc_url($settings['mc_form_url']); ?>">
                <input type="email" class="formInput" name="EMAIL" placeholder="<?php echo esc_attr($settings['mc_input_placeholder']); ?>">
                <button type="submit" class="thm-btn footer-widget__mc-btn"><?php echo esc_html($settings['mc_btn_text']); ?></button>
            </form>
            <div class="mc-form__response"></div><!-- /.mc-form__response -->
        </div><!-- /.footer-widget footer-widget__subscribe -->
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Footer_MC());
