<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_FunFacts extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-funfact';
    }

    public function get_title()
    {
        return __('Zimed - FunFacts', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-bars';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content',
            [
                'label' => __('Contents', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'block_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one'  => __('Style One', 'zimed-core'),
                    'two' => __('Style Two', 'zimed-core'),
                    'three' => __('Style Three', 'zimed-core'),
                ],
                'default' => 'one',
            ]
        );


        $content_box = new Repeater();
        $content_box->add_control(
            'funfact_icon',
            [
                'label' => __('Add Icon', 'zimed-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => zimed_get_fa_icons(),
                'default' => 'zimed-icon-app-development',
            ]
        );
        $content_box->add_control(
            'funfact_title',
            [
                'label' => __('Add Counter', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $content_box->add_control(
            'funfact_text',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'funfact_box',
            [
                'label' => __('Funfact Box', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $content_box->get_controls(),
                'title_field' => '{{{ funfact_title.value }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <?php if ('one' === $settings['block_type']) : ?>
            <section class="funfact-one">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="funfact-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>

                <div class="container">
                    <div class="row">        <div class="col-lg-12 col-md-12">
                        
                                            <div class="block-title text-center">
                                        
                        <span class="block-title__bubbles"></span>
                        <h3>Features and <span>Benefits</span></h3>
                    </div><!-- /.block-title --></div>
                        </div>
                        <div class="row">
                        <?php
                        foreach ($settings['funfact_box'] as $funfact_box) : ?>
                            <div class="col-lg-3 col-md-6">
                                <div class="funfact-one__single">
                                    <div class="funfact-one__content">
                                        
                                        <p><?php echo wp_kses($funfact_box['funfact_text'], 'zimed_allowed_tags'); ?></p>
                                    </div><!-- /.funfact-one__content -->
                                </div><!-- /.funfact-one__single -->
                            </div><!-- /.col-lg-3 -->
                        <?php endforeach; ?>
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.funfact-one -->
        <?php endif; ?>

        <?php if ('two' === $settings['block_type']) : ?>
            <section class="funfact-two">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="funfact-two__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="block-title text-center">
                        <span class="block-title__bubbles"></span>
                        <h3>Features and <span>Benefits:</span></h3>
                        <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                        <h3><?php echo wp_kses($settings['block_title']); ?></h3>
                    </div><!-- /.block-title -->
                    <div class="row">
                        <?php
                        foreach ($settings['funfact_box'] as $funfact_box) : ?>
                            <div class="col-lg-3 col-md-6">
                                <div class="funfact-two__single-outer">
                                    <div class="funfact-two__single">
                                        <span class="funfact-two__dot-1"></span>
                                        <span class="funfact-two__dot-2"></span>
                                        <span class="funfact-two__dot-3"></span>
                                        <h3 class="funfact-two__title counter">
                                    <div class="funfact-one__icon">
                                        <i class="<?php echo esc_attr($funfact_box['funfact_icon']); ?>"></i>
                                    </div><!-- /.funfact-one__icon --><?php echo wp_kses($funfact_box['funfact_title'], 'zimed_allowed_tags'); ?></h3><!-- /.funfact-two__title -->
                                        <p class="funfact-two__tag-line"><?php echo wp_kses($funfact_box['funfact_text'], 'zimed_allowed_tags'); ?></p><!-- /.funfact-two__tag-line -->
                                    </div><!-- /.funfact-two__single -->
                                </div><!-- /.funfact-two__single-outer -->
                            </div><!-- /.col-lg-3 -->
                        <?php endforeach; ?>
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.funfact-two -->
        <?php endif; ?>

        <?php if ('three' === $settings['block_type']) : ?>
            <section class="funfact-one funfact-one__boxed">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="funfact-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>

                <div class="container">
                    <div class="row">
                        <?php
                        foreach ($settings['funfact_box'] as $funfact_box) : ?>
                            <div class="col-lg-3 col-md-6">
                                <div class="funfact-one__single">
                                    <div class="funfact-one__content">
                                        
                                    <div class="funfact-one__icon">
                                        <i class="<?php echo esc_attr($funfact_box['funfact_icon']); ?>"></i>
                                    </div><!-- /.funfact-one__icon -->
                                        <p><?php echo wp_kses($funfact_box['funfact_text'], 'zimed_allowed_tags'); ?></p>
                                    </div><!-- /.funfact-one__content -->
                                </div><!-- /.funfact-one__single -->
                            </div><!-- /.col-lg-3 -->
                        <?php endforeach; ?>
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.funfact-one -->
        <?php endif; ?>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_FunFacts());
