<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Screenshots extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-screenshots';
    }

    public function get_title()
    {
        return __('Zimed - Screenshots', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-grip-horizontal';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'block',
            [
                'label' => __('Block Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Contents', 'zimed-core')
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'thumb_image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'screenshots_content',
            [
                'label' => __('Image List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],

                ],
                'title_field' => '{{{thumb_image.id.index}}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="app-shot-one">
            <?php $bg_shapes_count = 1;
            foreach ($settings['bg_shapes'] as $bg_shape) {
                echo '<img src="' . $bg_shape['url'] . '" class="app-shot__shape-' . $bg_shapes_count . '" alt="">';
                $bg_shapes_count++;
            }
            ?>

            <div class="container-fluid">
                <div class="block-title text-center color-5">
                    <span class="block-title__bubbles"></span>
                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                </div><!-- /.block-title -->
                <div class="app-shot-one__carousel owl-theme owl-carousel thm__owl-carousel" data-options='{ "loop": true, "margin": 30, "nav": false, "dots": true, "autoWidth": false, "autoplay": true, "smartSpeed": 700, "autoplayTimeout": 5000, "autoplayHoverPause": true, "slideBy": 5, "responsive": {
                    "0": { "items": 1 },
                    "480": { "items": 2 },
                    "600": { "items": 3 },
                    "991": { "items": 4 },
                    "1000": { "items": 5 },
                    "1200": { "items": 5 }
                }}'>
                    <?php foreach ($settings['screenshots_content'] as $screenshot) : ?>
                        <div class="item">
                            <?php
                            $thumb_img = [];
                            $thumb_img_id = $screenshot['thumb_image']['id'];
                            if ('' == $thumb_img_id) {
                                $thumb_img = [
                                    0 => ZIMED_CORE_DIRECTORY_URL . 'assets/images/app-shot-1-1.jpg',
                                ];
                            } else {
                                $thumb_img = wp_get_attachment_image_src($thumb_img_id, 'zimed_core_278x471'); //use custom set size
                            }

                            ?>
                            <img src="<?php echo esc_url($thumb_img[0]); ?>" alt="<?php echo esc_html('Awesome Image', 'zimed-core'); ?>" />
                        </div><!-- /.item -->
                    <?php endforeach; ?>
                </div><!-- /.app-shot-one__carousel owl-theme owl-carousel -->
            </div><!-- /.container-fluid -->
        </section><!-- /.app-shot-one -->

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Screenshots());
