<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Service_One extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-service-one';
    }

    public function get_title()
    {
        return __('Zimed - Service One', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-tag';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'block',
            [
                'label' => __('Section Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'box',
            [
                'label' => __('Boxes', 'zimed-core')
            ]
        );

        $content_box = new Repeater();

        $content_box->add_control(
            'content_box_icon',
            [
                'label' => __('Add Icon', 'zimed-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => zimed_get_fa_icons(),
                'default' => 'zimed-icon-app-development',
            ]
        );
        $content_box->add_control(
            'content_box_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'contents_box',
            [
                'label' => __('Content Box', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $content_box->get_controls(),
                'title_field' => '{{{ content_box_title.value }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="service-one">
            <div class="container">
                <div class="block-title text-center">
                    <span class="block-title__bubbles"></span>
                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                </div><!-- /.block-title -->
                <div class="row">
                    <?php foreach ($settings['contents_box'] as $box) : ?>
                        <div class="service-one__col wow fadeInUp" data-wow-duration="1500ms" data-wow-delay="000ms">
                            <div class="service-one__single">
                                <div class="service-one__icon">
                                    <i class="<?php echo esc_attr($box['content_box_icon']); ?>"></i>
                                </div><!-- /.service-one__icon -->
                                <h3><?php echo wp_kses($box['content_box_title'], 'zimed_allowed_tags'); ?></h3>
                            </div><!-- /.service-one__single -->
                        </div><!-- /.service-one__col -->
                    <?php endforeach; ?>
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.service-one -->

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Service_One());
