<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Service_Two extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-service-two';
    }

    public function get_title()
    {
        return __('Zimed - Service Two', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-tag';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'block',
            [
                'label' => __('Section Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'box',
            [
                'label' => __('Boxes', 'zimed-core')
            ]
        );

        $content_box = new Repeater();

        $content_box->add_control(
            'content_box_icon',
            [
                'label' => __('Add Icon', 'zimed-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => zimed_get_fa_icons(),
                'default' => 'zimed-icon-app-development',
            ]
        );
        $content_box->add_control(
            'content_box_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $content_box->add_control(
            'content_box_text',
            [
                'label' => __('Add Text', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $content_box->add_control(
            'content_box_link',
            [
                'label' => __('Add Link', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'contents_box',
            [
                'label' => __('Content Box', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $content_box->get_controls(),
                'title_field' => '{{{ content_box_title.value }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="service-two">
            <?php $bg_shapes_count = 1;
            foreach ($settings['bg_shapes'] as $bg_shape) {
                echo '<img src="' . $bg_shape['url'] . '" class="service-two__shape-' . $bg_shapes_count . '" alt="">';
                $bg_shapes_count++;
            }
            ?>
            <div class="container">
                <?php if (!empty($settings['block_title'])) : ?>
                    <div class="block-title text-center">
                        <span class="block-title__bubbles"></span>
                        <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                        <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                    </div><!-- /.block-title -->
                <?php endif; ?>
                <div class="row">
                    <?php foreach ($settings['contents_box'] as $box) : ?>
                        <div class="col-lg-4">
                            <div class="service-two__single icon-box-wrapper">
                                <div class="service-two__icon icon-box-with-bubble">
                                    <i class="<?php echo esc_attr($box['content_box_icon']); ?>"></i>
                                </div><!-- /.service-two__icon -->
                                <h3 class="service-two__title"><a href="<?php echo esc_url($box['content_box_link']); ?>"><?php echo wp_kses($box['content_box_title'], 'zimed_allowed_tags'); ?></a></h3>
                                <p class="service-two__text"><?php echo wp_kses($box['content_box_text'], 'zimed_allowed_tags'); ?></p><!-- /.service-two__text -->
                                <a href="<?php echo esc_url($box['content_box_link']); ?>" class="service-two__btn"><span><?php esc_html_e('Read More', 'zimed-core'); ?></span></a>
                            </div><!-- /.service-two__single -->
                        </div><!-- /.col-lg-4 -->
                    <?php endforeach; ?>
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.service-one -->

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Service_Two());
