<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Team extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-team';
    }

    public function get_title()
    {
        return __('Zimed - Team', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-users';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'settings',
            [
                'label' => __('Settings', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'col_size',
            [
                'label' => __('Column Size', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'col-lg-12'  => __('One Column', 'zimed-core'),
                    'col-lg-6' => __('Two Column', 'zimed-core'),
                    'col-lg-4' => __('Three Column', 'zimed-core'),
                    'col-lg-3' => __('Four Coumn', 'zimed-core'),
                ],
                'default' => 'col-lg-3',
            ]
        );
        $this->add_control(
            'post_count',
            [
                'label' => __('Post Count', 'zimed-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 3,
                ],
            ]
        );



        $this->end_controls_section();

        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Add Background Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <section class="team-one" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);">
            <?php
            $bg_shape_count = 1;
            foreach ($settings['bg_shapes'] as $bg_shape) {
                echo '<img src="' . $bg_shape['url'] . '" alt="" class="team-one__bg-shape-' . $bg_shape_count . '">';
                $bg_shape_count++;
            }
            ?>
            <div class="container">
                <div class="block-title text-center color-5">
                    <span class="block-title__bubbles"></span>
                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                </div><!-- /.block-title -->
                <div class="row">

                    <?php
                    $team_query = new \WP_Query(array(
                        'post_type' => 'team',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'modified',
                        'posts_per_page' => $settings['post_count']['size']
                    ));
                    ?>
                    <?php while ($team_query->have_posts()) : ?>
                        <?php $team_query->the_post(); ?>
                        <div class="<?php echo esc_attr($settings['col_size']); ?> col-md-6 col-sm-12">
                            <div id="post-<?php the_ID(); ?>" <?php post_class('team-one__single'); ?>>
                                <div class="team-one__image">
                                    <?php the_post_thumbnail('zimed_core_270x252'); ?>

                                </div><!-- /.team-one__image -->

                                <div class="team-one__content">
                                    <h3><?php the_title(); ?></h3>
                                    <p><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_designation', true)); ?></p>

                                </div><!-- /.team-one__content -->

                                <div class="team-one__hover">
                                    <h3><?php the_title(); ?></h3>
                                    <p><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_designation', true)); ?></p>
                                    <div class="team-one__social">
                                        <?php $social_profiles = get_post_meta(get_the_ID(), '_zimed_team_social', true); ?>
                                        <?php foreach ($social_profiles as $social_profile) : ?>
                                            <a href="<?php echo esc_url($social_profile['_zimed_link']); ?>" class="fab <?php echo esc_attr($social_profile['_zimed_icon']); ?>"></a>
                                        <?php endforeach; ?>
                                    </div><!-- /.team-one__social -->
                                </div><!-- /.team-one__hover -->

                            </div><!-- /.team-one__single -->
                        </div><!-- /.col-lg-3 -->
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>

                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.blog-one -->
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Team());
