<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Testimonials extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-testimonials';
    }

    public function get_title()
    {
        return __('Zimed - Testimonials', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-comments';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'block',
            [
                'label' => __('Section Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one'  => __('Style One', 'zimed-core'),
                    'two' => __('Style Two', 'zimed-core'),
                    'three' => __('Style Three', 'zimed-core'),
                    'four' => __('Style Four', 'zimed-core'),
                ],
                'default' => 'one',
            ]
        );


        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'block_summery',
            [
                'label' => __('Add Summery', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Content Options', 'zimed-core')
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $repeater->add_control(
            'designation',
            [
                'label' => __('Add Designation', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'thumb_image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->add_control(
            'testimonials_content',
            [
                'label' => __('Testimonials List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],

                ],
                'title_field' => '{{{thumb_image.id.index}}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Add Background Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->add_control(
            'bg_map',
            [
                'label' => __('Background Map', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <?php if ('one' === $settings['layout_type']) : ?>
            <section class="testimonials__one">
                
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="testimonials__one-shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 d-flex">
                            <div class="my-auto">
                                <div id="testimonials-slider-pager">
                                    <div class="testimonials-slider-pager-one">
                                        <img src="https://ryan-designs.net/sz/wp-content/uploads/2023/03/vector.png">
                                    </div><!-- /.testimonials-slider-pager-one -->
                                    <div class="testimonials-slider-pager-two">
                                
                                    </div><!-- /.testimonials-slider-pager-two -->
                                </div><!-- /#testimonials-slider-pager -->
                            </div><!-- /.my-auto -->
                        </div><!-- /.col-lg-6 -->
                        <div class="col-lg-6">
                            <div class="block-title text-left color-3">
                                <span class="block-title__bubbles"></span>
                                <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                                <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                            </div><!-- /.block-title -->
             <ul class="slider testimonials-slider">
    <?php
    $testi_thumb_count_two = 1;
    foreach ($settings['testimonials_content'] as $testimonial_content) :
        $thumb_img_two = [];
        $thumb_img_id_two = $testimonial_content['thumb_image']['id'];
        if ('' == $thumb_img_id_two) {
            $thumb_img_two = [
                0 => ZIMED_CORE_DIRECTORY_URL . 'assets/images/testi-1-1.jpg`',
            ];
        } else {
            $thumb_img_two = wp_get_attachment_image_src($thumb_img_id_two, 'zimed_core_164x164'); //use custom set size
        }
    ?>
        <li class="slide-item">
            <div class="testimonials__one__single">
                <p><?php echo wp_kses($testimonial_content['content'], 'zimed_allowed_tags'); ?></p>
<div class="testimonials__one__thumb">
    <div class="testimonials__one__thumb-img">
        <img src="<?php echo esc_url($thumb_img_two[0]); ?>" alt="Awesome Image" />
    </div>
    <div class="testimonials__one__thumb-content">
        <h3><?php echo wp_kses($testimonial_content['title'], 'zimed_allowed_tags'); ?></h3>
        <span><?php echo wp_kses($testimonial_content['designation'], 'zimed_allowed_tags'); ?></span>
    </div>
</div>

            </div><!-- /.testimonials__one__single -->
        </li>
    <?php endforeach; ?>
</ul>

                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.testimonials__one -->
        <?php endif; ?>

        <?php if ('two' === $settings['layout_type']) : ?>
            <section class="testimonials-two" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="testimonials__two-shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="testimonials-two__image-block">
                                <div class="owl-carousel owl-theme" id="sync2">
                                    <?php foreach ($settings['testimonials_content'] as $testimonial_thumb_two) :
                                        $thumb_img_two = [];
                                        $thumb_img_id_two = $testimonial_thumb_two['thumb_image']['id'];
                                        if ('' == $thumb_img_id_two) {
                                            $thumb_img_two = [
                                                0 => ZIMED_CORE_DIRECTORY_URL . 'assets/images/testi-2-1.jpg`',
                                            ];
                                        } else {
                                            $thumb_img_two = wp_get_attachment_image_src($thumb_img_id_two, 'zimed_core_451x451'); //use custom set size
                                        }

                                    ?>
                                        <div class="item clearfix">
                                            <div class="testimonials-two__image">
                                                <div class="testimonials-two__qoute">
                                                    
                                                </div><!-- /.testimonials-two__qoute -->
                                            </div><!-- /.testimonials-two__image -->
                                        </div><!-- /.item -->
                                    <?php endforeach; ?>
                                </div><!-- /.owl-carousel owl-theme -->
                                <div class="testimonials-two__button-block">
                                    <button class="testimonials-two__button__prev-btn"></button>
                                    <button class="testimonials-two__button__current-btn"></button>
                                    <button class="testimonials-two__button__next-btn"></button>
                                </div>
                            </div><!-- /.testimonials-two__image-block -->
                        </div><!-- /.col-lg-6 -->
                        <div class="col-lg-6">
                            <div class="testimonials-two__content">
                                <div class="block-title color-3 text-left">
                                    <span class="block-title__bubbles"></span>
                                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                                </div><!-- /.block-title -->
                                <div class="owl-carousel owl-theme" id="sync1">
                                    <?php
                                    foreach ($settings['testimonials_content'] as $testimonial_content) : ?>
                                        <div class="item">
                                            <div class="testimonials-two__single" data-thumb-img="<?php echo esc_url($testimonial_content['thumb_image']['url']); ?>">
                                                <p class="testimonials-two__text"><?php echo wp_kses($testimonial_content['content'], 'zimed_allowed_tags'); ?></p><!-- /.testimonials-two__text -->
                                                <div class="testimonials-two__bottom">
                                                    <h3 class="testimonials-two__title"><?php echo wp_kses($testimonial_content['title'], 'zimed_allowed_tags'); ?></h3><!-- /.testimonials-two__title -->
                                                    <span class="testimonials-two__designation"><?php echo wp_kses($testimonial_content['designation'], 'zimed_allowed_tags'); ?></span><!-- /.testimonials-two__designation -->
                                                </div><!-- /.testimonials-two__bottom -->
                                            </div><!-- /.testimonials-two__single -->
                                        </div><!-- /.item -->
                                    <?php endforeach; ?>
                                </div><!-- /.owl-carousel owl-theme -->
                            </div><!-- /.testimonials-two__content -->
                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.testimonials-two -->
        <?php endif; ?>

        <?php if ('three' === $settings['layout_type']) : ?>
            <section class="testimonials-three" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="testimonials__three-shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="block-title color-3 text-left">
                                <span class="block-title__bubbles"></span>
                                <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                                <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                            </div><!-- /.block-title -->
                        </div><!-- /.col-lg-7 -->
                        <div class="col-lg-5">
                            <div class="block-summery">
                                <p><?php echo wp_kses($settings['block_summery'], 'zimed_allowed_tags'); ?> </p>
                            </div><!-- /.block-summery -->
                        </div><!-- /.col-lg-5 -->
                    </div><!-- /.row -->
                    <div class="owl-carousel thm__owl-carousel owl-theme" data-options='{"nav": false, "autoplay": true, "autoplayTimeout": 5000, "smartSpeed": 700, "dots": true, "margin": 30, "loop": true, "responsive": { "0": { "items": 1, "nav": false, "dots": true }, "767": { "items": 1, "nav": false, "dots": true }, "991": { "items": 2 }, "1199": { "items": 2 }, "1200": { "items": 3 } }}'>
                        <?php
                        foreach ($settings['testimonials_content'] as $testimonial_content) :

                            $thumb_image_three = [];
                            $thumb_image_three_id = $testimonial_content['thumb_image']['id'];
                            if ('' == $thumb_image_three_id) {
                                $thumb_image_three = [
                                    0 => ZIMED_CORE_DIRECTORY_URL . 'assets/images/testi-2-1.jpg`',
                                ];
                            } else {
                                $thumb_image_three = wp_get_attachment_image_src($thumb_image_three_id, 'zimed_core_451x451'); //use custom set size
                            }

                        ?>
                            <div class="item">
                                <div class="testimonials-three__single">
                                    <p class="testimonials-three__text"><?php echo wp_kses($testimonial_content['content'], 'zimed_allowed_tags'); ?></p><!-- /.testimonials-two__text -->
                                    <div class="testimonials-three__bottom">
                                        <h3 class="testimonials-three__title"><?php echo wp_kses($testimonial_content['title'], 'zimed_allowed_tags'); ?></h3><!-- /.testimonials-three__title -->
                                        <span class="testimonials-three__designation"><?php echo wp_kses($testimonial_content['designation'], 'zimed_allowed_tags'); ?></span><!-- /.testimonials-three__designation -->
                                    </div><!-- /.testimonials-three__bottom -->
                                    <img width="73" height="73" src="<?php echo esc_url($thumb_image_three[0]); ?>" class="testimonials-three__thumb" alt="<?php echo wp_kses($testimonial_content['title'], 'zimed_allowed_tags'); ?>" />
                                </div><!-- /.testimonials-three__single -->
                            </div><!-- /.item -->
                        <?php endforeach; ?>
                    </div><!-- /.owl-carousel thm__owl-carousel owl-theme -->
                </div><!-- /.container -->
            </section><!-- /.testimonials-two -->
        <?php endif; ?>

        <?php if ('four' === $settings['layout_type']) : ?>
            <div class="testimonials-four">
                <div class="container">
                    <div class="row">
                        <?php
                        foreach ($settings['testimonials_content'] as $testimonial_content) :

                            $thumb_image_three = [];
                            $thumb_image_three_id = $testimonial_content['thumb_image']['id'];
                            if ('' == $thumb_image_three_id) {
                                $thumb_image_three = [
                                    0 => ZIMED_CORE_DIRECTORY_URL . 'assets/images/testi-2-1.jpg`',
                                ];
                            } else {
                                $thumb_image_three = wp_get_attachment_image_src($thumb_image_three_id, 'zimed_core_451x451'); //use custom set size
                            }

                        ?>
                            <div class="col-md-6 col-lg-4">
                                <div class="testimonials-three__single">
                                    <p class="testimonials-three__text"><?php echo wp_kses($testimonial_content['content'], 'zimed_allowed_tags'); ?></p><!-- /.testimonials-two__text -->
                                    <div class="testimonials-three__bottom">
                                        <h3 class="testimonials-three__title"><?php echo wp_kses($testimonial_content['title'], 'zimed_allowed_tags'); ?></h3><!-- /.testimonials-three__title -->
                                        <span class="testimonials-three__designation"><?php echo wp_kses($testimonial_content['designation'], 'zimed_allowed_tags'); ?></span><!-- /.testimonials-three__designation -->
                                    </div><!-- /.testimonials-three__bottom -->
                                    <img width="73" height="73" src="<?php echo esc_url($thumb_image_three[0]); ?>" class="testimonials-three__thumb" alt="<?php echo wp_kses($testimonial_content['title'], 'zimed_allowed_tags'); ?>" />
                                </div><!-- /.testimonials-three__single -->

                            </div><!-- /.col-md-6 col-lg-4 -->
                        <?php endforeach; ?>


                    </div><!-- /.row -->
                </div><!-- /.container -->
            </div><!-- /.testimonials-four -->
        <?php endif; ?>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Testimonials());
