<?php


/**
 * defined theme image size
 */

add_image_size('zimed_core_78x78', 79, 78, true); // testimonials thumbnail
add_image_size('zimed_core_350x289', 350, 289, true); // blog thumbnail
add_image_size('zimed_core_125x25', 125, 25, true); // brand thumbnail
add_image_size('zimed_core_164x164', 164, 164, true); // testimonials thumbnail 2
add_image_size('zimed_core_278x471', 278, 471, true); // app screenshot size
add_image_size('zimed_core_451x451', 451, 451, true); // testimonials 2 size
add_image_size('zimed_core_270x252', 270, 252, true); // team size
add_image_size('zimed_core_370x417', 370, 417, true); // gallery size



if (!function_exists('zimed_get_fa_icons')) :

    function zimed_get_fa_icons()
    {
        $data = get_transient('zimed_fa_icons');


        if (empty($data)) {
            global $wp_filesystem;
            require_once(ABSPATH . '/wp-admin/includes/file.php');
            WP_Filesystem();

            $fontAwesome_file =  ZIMED_CORE_DIRECTORY_PATH . '/assets/css/fontawesome-all.min.css';
            $template_icon_file = ZIMED_CORE_DIRECTORY_PATH . '/assets/css/zimed-icon.css';
            $template_icon_file_new = ZIMED_CORE_DIRECTORY_PATH . '/assets/css/zimed-new-icon.css';
            $content = '';

            if ($wp_filesystem->exists($fontAwesome_file)) {
                $content = $wp_filesystem->get_contents($fontAwesome_file);
            } // End If Statement

            if ($wp_filesystem->exists($template_icon_file)) {
                $content .= $wp_filesystem->get_contents($template_icon_file);
            } // End If Statement

            if ($wp_filesystem->exists($template_icon_file_new)) {
                $content .= $wp_filesystem->get_contents($template_icon_file_new);
            } // End If Statement



            $pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s*{\s*content/';
            $pattern_two = '/\.(zimed-icon-(?:\w+(?:-)?)+):before\s*{\s*content/';
            $pattern_three = '/\.(zimed-new-icon-(?:\w+(?:-)?)+):before\s*{\s*content/';

            $subject = $content;

            preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);
            preg_match_all($pattern_two, $subject, $matches_two, PREG_SET_ORDER);
            preg_match_all($pattern_three, $subject, $matches_three, PREG_SET_ORDER);

            $all_matches = array_merge($matches, $matches_two, $matches_three);

            $icons = array();

            foreach ($all_matches as $match) {
                // $icons[] = array('value' => $match[1], 'label' => $match[1]);
                $icons[] = $match[1];
            }


            $data = $icons;
            set_transient('zimed_fa_icons', $data, 10080); // saved for one week

        }

        return array_combine($data, $data); // combined for key = value
    }


endif;



if (function_exists('wpcf7')) {
    function zimed_select_contact_form()
    {
        $wpcf7_form_list = get_posts(array(
            'post_type' => 'wpcf7_contact_form',
            'showposts' => -1,
        ));
        $posts = array();

        if (!empty($wpcf7_form_list) && !is_wp_error($wpcf7_form_list)) {
            foreach ($wpcf7_form_list as $post) {
                $options[$post->ID] = $post->post_title;
            }
            return $options;
        }
    }
}


// custom kses allowed html
if (!function_exists('zimed_kses_allowed_html')) :
    function zimed_kses_allowed_html($tags, $context)
    {
        switch ($context) {
            case 'zimed_allowed_tags':
                $tags = array(
                    'a' => array('href' => array(), 'class' => array()),
                    'b' => array(),
                    'br' => array(),
                    'span' => array('class' => array()),
                    'img' => array('class' => array()),
                    'i' => array('class' => array()),
                    'p' => array('class' => array()),
                    'ul' => array('class' => array()),
                    'li' => array('class' => array()),
                    'div' => array('class' => array()),
                    'strong' => array()
                );
                return $tags;
            default:
                return $tags;
        }
    }

    add_filter('wp_kses_allowed_html', 'zimed_kses_allowed_html', 10, 2);

endif;




if (!function_exists('zimed_posted_on')) :
    /**
     * Prints HTML with meta information for the current post-date/time
     * @param string $element_class_prefix Classes for the element.
     */
    function zimed_posted_on($element_class_prefix)
    {
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        if (get_the_time('U') !== get_the_modified_time('U')) {
            $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
        }

        $time_string = sprintf(
            $time_string,
            esc_attr(get_the_date(DATE_W3C)),
            esc_html(get_the_date()),
            esc_attr(get_the_modified_date(DATE_W3C)),
            esc_html(get_the_modified_date())
        );

        $posted_on = sprintf(
            /* translators: %s: post date. */
            esc_html_x('%s', 'post date', 'zimed'),
            '<a class="' . $element_class_prefix . '__date" href="' . esc_url(get_permalink()) . '" rel="bookmark">' . $time_string . '</a>'
        );

        echo  wp_kses($posted_on, 'zimed_allowed_tags'); // WPCS: XSS OK.

    }
endif;

if (!function_exists('zimed_posted_by')) :
    /**
     * Prints HTML with meta information for the current author.
     * @param string $element_class_prefix Classes for the element.
     */
    function zimed_posted_by($element_class_prefix)
    {
        $byline = sprintf(
            /* translators: %s: post author. */
            esc_html_x('%s', 'post author', 'zimed'),
            '<span class="byline"> <span class="author vcard"><a class="' . esc_attr($element_class_prefix) . '__meta-link url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '"> <i class="far fa-clock"></i>' . esc_html(get_the_author()) . '</a></span></span>'
        );

        echo wp_kses($byline, 'zimed_allowed_tags'); // WPCS: XSS OK.

    }
endif;

if (!function_exists('zimed_comments_meta')) :
    /**
     * Prints HTML with meta information for the current post comments.
     * @param string $element_class_prefix Classes for the element.
     */
    function zimed_comments_meta($element_class_prefix)
    {
        if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) {

            echo wp_kses('<span class="comments-link"> <i class="far fa-comments"></i>', 'zimed_allowed_tags');
            comments_popup_link(
                esc_html__('Post a Comment', 'zimed'),
                esc_html__('1 Comment', 'zimed'),
                esc_html__('% Comments', 'zimed'),
                $element_class_prefix . '__meta-link',
                esc_html__('Comments are Closed', 'zimed')
            );
            echo wp_kses('</span>', 'zimed_allowed_tags');
        }
    }
endif;

if (!function_exists('zimed_pagination')) :
    /**
     * Prints HTML with post pagination links.
     */
    function zimed_pagination()
    {
        global $wp_query;
        $links = paginate_links(array(
            'current'   => max(1, get_query_var('paged')),
            'total'     => $wp_query->max_num_pages,
            'prev_text' => '<i class="fa fa-angle-left"></i>',
            'next_text' => '<i class="fa fa-angle-right"></i>',
        ));
        echo wp_kses($links, 'zimed_allowed_tags');
    }
endif;

if (!function_exists('zimed_custom_query_pagination')) :
    /**
     * Prints HTML with post pagination links.
     */
    function zimed_custom_query_pagination($paged = '', $max_page = '')
    {

        $big = 999999999; // need an unlikely integer
        if (!$paged)
            $paged = get_query_var('paged');
        if (!$max_page)
            $max_page = $wp_query->max_num_pages;

        $links = paginate_links(array(
            'base'       => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format'     => '?paged=%#%',
            'current'    => max(1, $paged),
            'total'      => $max_page,
            'mid_size'   => 1,
            'prev_text' => '<i class="fa fa-angle-left"></i>',
            'next_text' => '<i class="fa fa-angle-right"></i>',
        ));

        echo wp_kses($links, 'zimed_allowed_tags');
    }
endif;


if (!function_exists('zimed_post_thumbnail')) :
    /**
     * Displays an optional post thumbnail.
     *
     * Wraps the post thumbnail in an anchor element on index views, or a div
     * element when on single views.
     * @param boolean $fallback_div div for no thumbnails.
     */
    function zimed_post_thumbnail($image_size = 'post-thumbnail')
    {
        if (post_password_required() || is_attachment() || !has_post_thumbnail()) {
            return;
        }
        if (is_singular()) :
            the_post_thumbnail($image_size, array(
                'class' => 'img-fluid',
                'alt' => the_title_attribute(array(
                    'echo' => false,
                )),
            ));

        else :

            the_post_thumbnail($image_size, array(
                'class' => 'img-fluid',
                'alt' => the_title_attribute(array(
                    'echo' => false,
                )),
            ));

        endif; // End is_singular().
    }
endif;
