<?php
get_header(); // Include the header.php file
?>

<div id="primary" class="content-area">
    <main id="main" class="site-main" role="main">

        <?php while (have_posts()) : the_post(); ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <header class="entry-header">
                    <h1 class="entry-title"><?php the_title(); ?></h1>
                </header>

                <div class="entry-content">
                    <div class="row">
                        <?php
                        // Get the custom post meta values
                        $shoes = get_post_meta(get_the_ID(), 'shoes', true);
                        $pants = get_post_meta(get_the_ID(), 'pants', true);
                        $shirt = get_post_meta(get_the_ID(), 'shirt', true);
                        $jacket = get_post_meta(get_the_ID(), 'jacket', true);
                        $accessory = get_post_meta(get_the_ID(), 'accessory', true);

                        // Store the custom post meta values in an array
                        $post_meta_values = array(
                            'Shoes' => $shoes,
                            'Pants' => $pants,
                            'Shirt' => $shirt,
                            'Jacket' => $jacket,
                            'Accessory' => $accessory
                        );

                        foreach ($post_meta_values as $field_name => $field_value) {
                            // Check if the field value is empty
                            if (empty($field_value)) {
                                $placeholder_image_url = 'https://ryan-designs.net/sz/wp-content/uploads/2023/03/logosm1.png'; // Replace with your placeholder image URL
                                $image_markup = '<img src="' . $placeholder_image_url . '" alt="' . $field_name . '">';
                                $amazon_search_link = '';
                            } else {
                                // Perform Google image search
                                $search_query = urlencode($field_value);
                                           $google_api_key = 'AIzaSyAJeEaHdJvu7kk2S3axyZx6Yth5ecayMkk';
                                    $google_cse_id = '14aa5575c9fec4fe7';
                                $google_search_url = 'https://www.googleapis.com/customsearch/v1?key=' . $google_api_key . '&cx=' . $google_cse_id . '&q=' . $search_query . '&searchType=image&imgSize=medium&num=1';

                                $response = wp_remote_get($google_search_url);

                                if (is_wp_error($response)) {
                                    $image_markup = 'Failed to retrieve search results.';
                                } else {
                                    $body = wp_remote_retrieve_body($response);
                                    $data = json_decode($body);

                                    if (isset($data->items) && !empty($data->items)) {
                                        $image_url = $data->items[0]->link;

                                        $image_markup = '<img src="' . $image_url . '" alt="' . $field_name . '">';

                                        // Generate Amazon search link
                                        $amazon_search_query = urlencode($field_value);
                                        $amazon_affiliate_link = 'https://www.amazon.com/s?k=' . $amazon_search_query . '&tag=YOUR_AFFILIATE_TAG';

                                        $amazon_search_link = '<a href="' . $amazon_affiliate_link . '">Search on Amazon</a>';
                                    } else {
                                        $image_markup = 'No image found.';
                                        $amazon_search_link = ''; // Set the variable to an empty string
                                    }
                                }
                            }
                            ?>

                            <div class="col-md-2">
                                <div class="text-center">
                                    <?php echo $image_markup; ?>
                                                                        <h4><?php echo $field_name; ?></h4>
                                    <p><?php echo $field_value; ?></p>
                                    <?php echo $amazon_search_link; ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div><!-- .entry-content -->
            </article><!-- #post-<?php the_ID(); ?> -->
        <?php endwhile; ?>

    </main><!-- #main -->
</div><!-- #primary -->

<?php get_footer(); // Include the footer.php file ?>
