<?php
/*
Template Name: User Shoes
*/

// Get the current user's ID
$current_user_id = get_current_user_id();

// Get the shoes for the current user
$args = array(
    'post_type' => 'outfits',
    'posts_per_page' => 1,
    'meta_query' => array(
        array(
            'key' => 'user_id',
            'value' => $current_user_id,
        ),
    ),
);
$query = new WP_Query($args);

// Check if the query returned any posts
if ($query->have_posts()) {
    while ($query->have_posts()) {
        $query->the_post();
        // Get the shoes field value
        $shoes = get_field('shoes');

        // Display the shoes for the current user
        echo '<p>Shoes: ' . $shoes . '</p>';
    }

    // Restore original post data
    wp_reset_postdata();
} else {
    // If no posts were found, display a message
    echo '<p>No shoes found for the current user.</p>';
}
?>
