<?php

add_action('cmb2_admin_init', 'zimed_pricing_metabox');

function zimed_pricing_metabox()
{
	$prefix = '_zimed_';


	$cmb = new_cmb2_box(array(
		'id'           => $prefix . 'pricing_content',
		'title'        => __('Pricing Content', 'zimed'),
		'object_types' => array('pricing'),
		'context'      => 'normal',
		'priority'     => 'default',
	));

	$cmb->add_field(array(
		'name' => __('Pricing Icon', 'zimed'),
		'id' => $prefix . 'pricing_icon',
		'type' => 'select',
		'options' => zimed_get_fa_icons()
	));

	$cmb->add_field(array(
		'name' => __('Currency Type', 'zimed'),
		'id' => $prefix . 'pricing_currency',
		'type' => 'text',
	));

	$cmb->add_field(array(
		'name' => __('Renewal Fee', 'zimed'),
		'id' => $prefix . 'pricing_renewal_fee',
		'type' => 'text',
	));


	$cmb->add_field(array(
		'name' => __('Plan Options', 'zimed'),
		'id' => $prefix . 'pricing_options',
		'type' => 'text',
		'repeatable' => true,
	));

	$cmb->add_field(array(
		'name' => __('Btn Label', 'zimed'),
		'id' => $prefix . 'pricing_btn_label',
		'type' => 'text',
	));

	$cmb->add_field(array(
		'name' => __('Btn URL', 'zimed'),
		'id' => $prefix . 'pricing_btn_url',
		'type' => 'text',
	));

	$cmb->add_field(array(
		'name' => __('Pricing Tagline', 'zimed'),
		'id' => $prefix . 'pricing_tagline',
		'type' => 'text',
	));
}
