<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Banner_One extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-banner-one';
    }

    public function get_title()
    {
        return __('Zimed - Banner', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-sliders';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout',
            [
                'label' => __('Select Layout', 'zimed-core')
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one'  => __('Style One', 'zimed-core'),
                    'two' => __('Style Two', 'zimed-core'),
                ],
                'default' => 'one',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'block',
            [
                'label' => __('Content', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Default Title', 'zimed-core'),
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Lorem ipsum dolor sit amet consectetur adipisicing elit. Sint aperiam recusandae, magni doloribus accusamus, nihil molestiae perferendis et, deleniti explicabo soluta. Unde laudantium, ab alias beatae enim sit deleniti iste.', 'zimed-core'),
            ]
        );
        $this->add_control(
            'block_tagline',
            [
                'label' => __('Add Tagline', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Default Tagline', 'zimed-core'),
            ]
        );
        $this->add_control(
            'btn_label',
            [
                'label' => __('Btn Label', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Button Label', 'zimed-core'),
            ]
        );

        $this->add_control(
            'btn_url',
            [
                'label' => __('Btn URL', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('#', 'zimed-core'),
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label' => __('Add Video URL', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'images_block',
            [
                'label' => __('Images', 'zimed-core')
            ]
        );


        $this->add_control(
            'image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'container_shape_image',
            [
                'label' => __('Container Shape Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __('Background Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <?php if ('one' === $settings['layout_type']) : ?>
            <section class="banner-one" style="background-image: url(<?php echo esc_url($settings['background_image']['url']); ?>);">

                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="banner-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>

                <div class="container">
                    <img src="<?php echo esc_url($settings['container_shape_image']['url']); ?>" alt="" class="banner-one__shape-moc-1">
                    <div class="row">
                        <div class="col-lg-7">
                            <div class="banner-one__content">
                                <p class="banner-one__tag-line"><?php echo wp_kses($settings['block_tagline'], 'zimed_allowed_tags'); ?></p>
                                <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                                <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                <div class="banner-one__btn-wrap">
                                    <a href="<?php echo esc_url($settings['btn_url']); ?>" class="thm-btn banner-one__btn"><?php echo esc_html($settings['btn_label']); ?></a><!-- /.thm-btn banner-one__btn -->
                                    <?php if (!empty($settings['video_url'])) : ?>
                                        <a href="<?php echo esc_url($settings['video_url']) ?>" class="video-popup"><i class="fa fa-play"></i></a>
                                    <?php endif; ?>
                                </div><!-- /.banner-one__btn-wrap -->

                            </div><!-- /.banner-one__content -->
                        </div><!-- /.col-lg-7 -->
                    </div><!-- /.row -->
                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="" class="banner-one__moc">
                </div><!-- /.container -->
            </section><!-- /.banner-one -->
        <?php endif; ?>

        <?php if ('two' === $settings['layout_type']) : ?>
            <section class="banner-two" style="background-image: url(<?php echo esc_url($settings['background_image']['url']); ?>);">
                <span class="banner-two__rect-1"></span>
                <span class="banner-two__rect-2"></span>
                <span class="banner-two__rect-3"></span>
                <span class="banner-two__rect-4"></span>
                <span class="banner-two__rect-5"></span>
                <span class="banner-two__rect-6"></span>

                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="banner-two__shape-image-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>

                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="banner-two__content">
                                <p class="banner-two__tag-line"><?php echo wp_kses($settings['block_tagline'], 'zimed_allowed_tags'); ?></p>
                                <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                                <a href="<?php echo esc_url($settings['btn_url']); ?>" class="thm-btn banner-two__btn"><?php echo esc_html($settings['btn_label']); ?></a><!-- /.thm-btn banner-one__btn -->
                            </div><!-- /.banner-one__content -->
                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="" class="banner-two__moc">
            </section>
        <?php endif; ?>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Banner_One());
