<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Blog_One extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-blog-one';
    }

    public function get_title()
    {
        return __('Zimed - Blog', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-receipt';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'block',
            [
                'label' => __('Block Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'post',
            [
                'label' => __('Post Options', 'zimed-core')
            ]
        );


        $this->add_control(
            'col_size',
            [
                'label' => __('Column Size', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'col-lg-12'  => __('One Column', 'zimed-core'),
                    'col-lg-6' => __('Two Column', 'zimed-core'),
                    'col-lg-4' => __('Three Column', 'zimed-core'),
                ],
                'default' => 'col-lg-4',
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('Post Count', 'zimed-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 9,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 3,
                ],
            ]
        );


        $this->end_controls_section();



        $this->start_controls_section(
            'screenshot_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <section class="blog-one blog-one__home">
            <?php $bg_shapes_count = 1;
            foreach ($settings['bg_shapes'] as $bg_shape) {
                echo '<img src="' . $bg_shape['url'] . '" class="blog-one__shape-' . $bg_shapes_count . '" alt="">';
                $bg_shapes_count++;
            }
            ?>
            <div class="container">
                <div class="block-title text-center color-4">
                    <span class="block-title__bubbles"></span>
                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                </div><!-- /.block-title -->
                <div class="row">

                    <?php
                    $blog_query = new \WP_Query(array(
                        'post_type' => 'post',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date',
                        'posts_per_page' => $settings['post_count']['size']
                    ));
                    ?>
                    <?php while ($blog_query->have_posts()) : ?>
                        <?php $blog_query->the_post(); ?>
                        <div class="<?php echo esc_attr($settings['col_size']); ?> col-md-12 col-sm-12 wow fadeInLeft" data-wow-duration="1500ms">
                            <div id="post-<?php the_ID(); ?>" <?php post_class('blog-one__single'); ?>>
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="blog-one__image">
                                        <?php wp_kses(zimed_post_thumbnail('zimed_core_350x289'), 'zimed_allowed_tags'); ?>
                                    </div><!-- /.blog-one__image -->
                                <?php endif; ?>
                                <div class="blog-one__content">
                                    <ul class="blog-one__meta list-unstyled">
                                        <li><?php zimed_posted_by('blog-one'); ?></li>
                                        <li><?php zimed_comments_meta('blog-one'); ?></li>
                                    </ul><!-- /.blog-one__meta list-unstyled -->
                                    <h3><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
                                    <a href="<?php echo esc_url(get_the_permalink()); ?>" class="blog-one__link"><i class="zimed-icon-right-arrow"></i></a>
                                    <!-- /.blog-one__link -->
                                </div><!-- /.blog-one__content -->
                            </div><!-- /.blog-one__single -->
                        </div><!-- /.col-lg-4 -->
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.blog-one -->
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Blog_One());
