<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Brands extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-brands';
    }

    public function get_title()
    {
        return __('Zimed - Brands', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-list-alt';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content',
            [
                'label' => __('Contents', 'zimed-core')
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'thumb_image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'thumb_text',
            [
                'label' => __('Add Text', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'brands_content',
            [
                'label' => __('Image List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'thumb_image' => [
                            'id' => '',
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],

                ],
                'title_field' => '{{{thumb_image.id.index}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout',
            [
                'label' => __('Layout Options', 'zimed-core')
            ]
        );


        $this->add_control(
            'layout_style',
            [
                'label' => __('Layout Styles', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_one'  => __('Layout One', 'zimed-core'),
                    'style_two'  => __('Layout Two', 'zimed-core'),
                ],
                'default' => 'style_one',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <?php if ('style_one' == $settings['layout_style']) : ?>
            <section class="brand-one brand-one__home-one">
                <div class="container">
                    <div class="brand-one__carousel owl-carousel thm__owl-carousel owl-theme" data-options='{"loop": true, "autoplay": true, "autoplayHoverPause": true, "autoplayTimeout": 5000, "items": 5, "dots": false, "nav": false, "margin": 140, "smartSpeed": 700, "responsive": { "0": {"items": 2, "margin": 30}, "480": {"items": 4, "margin": 30}, "992": {"items": 5, "margin": 50}, "1200": {"items": 5, "margin": 140}}}'>


                        <?php foreach ($settings['brands_content'] as $brand) : ?>
                            <div class="item">
                                <?php
                                $thumb_img = [];
                                $thumb_img_id = $brand['thumb_image']['id'];
                                if ('' == $thumb_img_id) {
                                    $thumb_img = [
                                        0 => ZIMED_CORE_DIRECTORY_URL . 'assets/images/brand-1-1.png',
                                    ];
                                } else {
                                    $thumb_img = wp_get_attachment_image_src($thumb_img_id, 'full'); //use custom set size
                                }

                                ?>
                                <?php if (!empty($brand['thumb_text'])) : ?>
                                    <div class="hover-text"><?php echo esc_html($brand['thumb_text']); ?></div><!-- /.hover-text -->
                                <?php endif; ?>
                                <img src="<?php echo esc_url($thumb_img[0]); ?>" alt="<?php echo esc_html('Awesome Image', 'zimed-core'); ?>" />
                            </div><!-- /.item -->
                        <?php endforeach; ?>


                    </div><!-- /.brand-one__carousel owl-carousel thm__owl-carousel owl-theme -->
                </div><!-- /.container -->
            </section><!-- /.brand-one -->
        <?php endif; ?>
        <?php if ('style_two' == $settings['layout_style']) : ?>
            <section class="brand-one brand-one__home-two">
                <div class="container">
                    <div class="brand-one__carousel owl-carousel thm__owl-carousel owl-theme" data-options='{"loop": true, "autoplay": true, "autoplayHoverPause": true, "autoplayTimeout": 5000, "items": 5, "dots": false, "nav": false, "margin": 140, "smartSpeed": 700, "responsive": { "0": {"items": 2, "margin": 30}, "480": {"items": 4, "margin": 30}, "992": {"items": 5, "margin": 50}, "1200": {"items": 5, "margin": 140}}}'>


                        <?php foreach ($settings['brands_content'] as $brand) : ?>
                            <div class="item">
                                <?php
                                $thumb_img = [];
                                $thumb_img_id = $brand['thumb_image']['id'];
                                if ('' == $thumb_img_id) {
                                    $thumb_img = [
                                        0 => ZIMED_CORE_DIRECTORY_URL . 'assets/images/brand-1-1.png',
                                    ];
                                } else {
                                    $thumb_img = wp_get_attachment_image_src($thumb_img_id, 'full'); //use custom set size
                                }

                                ?>

                                <?php if (!empty($brand['thumb_text'])) : ?>
                                    <div class="hover-text"><?php echo esc_html($brand['thumb_text']); ?></div><!-- /.hover-text -->
                                <?php endif; ?>
                                <img src="<?php echo esc_url($thumb_img[0]); ?>" alt="<?php echo esc_html('Awesome Image', 'zimed-core'); ?>" />
                            </div><!-- /.item -->
                        <?php endforeach; ?>


                    </div><!-- /.brand-one__carousel owl-carousel thm__owl-carousel owl-theme -->
                </div><!-- /.container -->
            </section><!-- /.brand-one -->
        <?php endif; ?>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Brands());
