<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Cta_Four extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-cta-four';
    }

    public function get_title()
    {
        return __('Zimed - Cta Four', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-bullhorn';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'block',
            [
                'label' => __('Section Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'zimed-core')
            ]
        );


        $list = new Repeater();

        $list->add_control(
            'list_text',
            [
                'label' => __('Add Text', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'list_box',
            [
                'label' => __('List Content', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $list->get_controls(),
                'title_field' => '{{{ list_text.value }}}',
            ]
        );


        $this->add_control(
            'paragraph',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'btn_label',
            [
                'label' => __('Btn Label', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'btn_url',
            [
                'label' => __('Btn URL', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Add Background Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="cta-four" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);">
            <?php $bg_shapes_count = 1;
            foreach ($settings['bg_shapes'] as $bg_shape) {
                echo '<img src="' . $bg_shape['url'] . '" class="cta-four__bg-shape-' . $bg_shapes_count . '" alt="">';
                $bg_shapes_count++;
            }
            ?>
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <img class="cta-four__image" src="<?php echo esc_attr($settings['image']['url']); ?>" alt="">
                    </div><!-- /.col-lg-6 -->
                    <div class="col-lg-6">
                        <div class="cta-four__content">
                            <div class="block-title text-left color-1">
                                <span class="block-title__bubbles"></span>
                                <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                            </div><!-- /.block-title -->
                            <p><?php echo wp_kses($settings['paragraph'], 'zimed_allowed_tags'); ?></p>
                            <ul class="list-unstyled">
                                <?php foreach ($settings['list_box'] as $list) : ?>
                                    <li><i class="fa fa-check"></i> <?php echo esc_html($list['list_text']); ?></li>
                                <?php endforeach; ?>
                            </ul><!-- /.list-unstyled -->
                            <a href="<?php echo esc_url($settings['btn_url']); ?>" class="thm-btn cta-four__btn"><?php echo esc_html($settings['btn_label']); ?></a><!-- /.thm-btn cta-four__btn -->
                        </div><!-- /.cta-four__content -->
                    </div><!-- /.col-lg-6 -->
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.cta-four -->

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Cta_Four());
