<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Cta_Three extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-cta-three';
    }

    public function get_title()
    {
        return __('Zimed - Cta Three', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-bullhorn';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'block',
            [
                'label' => __('Section Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one'  => __('Style One', 'zimed-core'),
                    'two' => __('Style Two', 'zimed-core'),
                ],
                'default' => 'one',
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'box',
            [
                'label' => __('Boxes', 'zimed-core')
            ]
        );

        $content_box = new Repeater();

        $content_box->add_control(
            'content_box_icon',
            [
                'label' => __('Add Icon', 'zimed-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => zimed_get_fa_icons(),
                'default' => 'zimed-icon-app-development',
            ]
        );
        $content_box->add_control(
            'content_box_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $content_box->add_control(
            'content_box_text',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'contents_box',
            [
                'label' => __('Content Box', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $content_box->get_controls(),
                'title_field' => '{{{ content_box_title.value }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'zimed-core')
            ]
        );



        $this->add_control(
            'image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'container_shape_image',
            [
                'label' => __('Container Shape Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <?php if ('one' === $settings['layout_type']) : ?>

            <div class="cta-three">
                <?php $bg_shapes_count = 2;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="cta-three__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <img src="<?php echo esc_url($settings['container_shape_image']['url']); ?>" alt="" class="cta-three__shape-1">
                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="" class="cta-three__moc">
                    <div class="row justify-content-end">
                        <div class="col-lg-6">
                            <div class="cta-three__content">
                                <div class="block-title text-left color-2">
                                    <span class="block-title__bubbles"></span>
                                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                                </div><!-- /.block-title -->
                                <div class="cta-three__box-wrap">
                                    <?php foreach ($settings['contents_box'] as $box) : ?>
                                        <div class="cta-three__box icon-box-wrapper">
                                            <div class="cta-three__box-icon icon-box-with-bubble">
                                                <i class="<?php echo esc_attr($box['content_box_icon']); ?>"></i>
                                            </div><!-- /.cta-three__box-icon -->
                                            <div class="cta-three__box-content">
                                                <h3><?php echo wp_kses($box['content_box_title'], 'zimed_allowed_tags'); ?></h3>
                                                <p><?php echo wp_kses($box['content_box_text'], 'zimed_allowed_tags'); ?></p>
                                            </div><!-- /.cta-three__box-content -->
                                        </div><!-- /.cta-three__box -->
                                    <?php endforeach; ?>
                                </div><!-- /.cta-three__box-wrap -->
                            </div><!-- /.cta-three__content -->
                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </div><!-- /.cta-three -->

        <?php endif; ?>

        <?php if ('two' === $settings['layout_type']) : ?>

            <div class="cta-three cta-three__style-two">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="cta-three__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="" class="cta-three__moc">
                <div class="container">
                    <div class="row justify-content-start">
                        <div class="col-lg-6">
                            <div class="cta-three__content">
                                <div class="block-title text-left color-3">
                                    <span class="block-title__bubbles"></span>
                                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                                </div><!-- /.block-title -->
                                <div class="cta-three__box-wrap">
                                    <?php foreach ($settings['contents_box'] as $box) : ?>
                                        <div class="cta-three__box icon-box-wrapper">
                                            <div class="cta-three__box-icon icon-box-with-bubble">
                                                <i class="<?php echo esc_attr($box['content_box_icon']); ?>"></i>
                                            </div><!-- /.cta-three__box-icon -->
                                            <div class="cta-three__box-content">
                                                <h3><?php echo wp_kses($box['content_box_title'], 'zimed_allowed_tags'); ?></h3>
                                                <p><?php echo wp_kses($box['content_box_text'], 'zimed_allowed_tags'); ?></p>
                                            </div><!-- /.cta-three__box-content -->
                                        </div><!-- /.cta-three__box -->
                                    <?php endforeach; ?>
                                </div><!-- /.cta-three__box-wrap -->
                                <a href="<?php echo esc_url($settings['btn_url']); ?>" class="thm-btn cta-three__btn"><?php echo esc_html($settings['btn_label']); ?></a><!-- /.thm-btn cta-three__btn -->
                            </div><!-- /.cta-three__content -->
                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </div><!-- /.cta-three -->

        <?php endif; ?>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Cta_Three());
