<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Cta_Two extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-cta-two';
    }

    public function get_title()
    {
        return __('Zimed - Cta Two', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-bullhorn';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'block',
            [
                'label' => __('Section Title', 'zimed-core')
            ]
        );


        $this->add_control(
            'layout_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one'  => __('Style One', 'zimed-core'),
                    'two' => __('Style Two', 'zimed-core'),
                    'three' => __('Style Three', 'zimed-core'),
                ],
                'default' => 'one',
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'zimed-core')
            ]
        );


        $this->add_control(
            'summery',
            [
                'label' => __('Add Text', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $list = new Repeater();

        $list->add_control(
            'list_text',
            [
                'label' => __('Add Text', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'list_box',
            [
                'label' => __('List Content', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $list->get_controls(),
                'title_field' => '{{{ list_text.value }}}',
            ]
        );


        $progress_line = new Repeater();

        $progress_line->add_control(
            'progress_line_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $progress_line->add_control(
            'progress_line_count',
            [
                'label' => __('Add Count', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'progress_line',
            [
                'label' => __('Progress Lines', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $progress_line->get_controls(),
                'title_field' => '{{{ progress_line_title.value }}}',
                'condition' => [
                    'layout_type' => ['one', 'two'],
                ]
            ]
        );


        $content_box = new Repeater();

        $content_box->add_control(
            'content_box_icon',
            [
                'label' => __('Add Icon', 'zimed-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => zimed_get_fa_icons(),
                'default' => 'zimed-icon-app-development',
            ]
        );
        $content_box->add_control(
            'content_box_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $content_box->add_control(
            'content_box_text',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'contents_box',
            [
                'label' => __('Content Box', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $content_box->get_controls(),
                'title_field' => '{{{ content_box_title.value }}}',
                'condition' => [
                    'layout_type' => ['three'],
                ]
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <?php if ('one' === $settings['layout_type']) : ?>
            <section class="cta-two">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="cta-two__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>

                <div class="container">
                    <img src="<?php echo esc_url($settings['image']['url']) ?>" alt="" class="cta-two__moc">
                    <div class="row">
                        <div class="col-xl-6 col-lg-6">
                            <div class="cta-two__content">
                                <div class="block-title text-left color-3">
                                    <span class="block-title__bubbles"></span>
                                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                                </div><!-- /.block-title -->
                                <p><?php echo wp_kses($settings['summery'], 'zimed_allowed_tags'); ?></p>
                                <ul class="list-unstyled cta-two__list">
                                    <?php foreach ($settings['list_box'] as $list) : ?>
                                        <li><i class="fa fa-check-circle"></i> <?php echo esc_html($list['list_text']); ?></li>
                                    <?php endforeach; ?>
                                </ul><!-- /.list-unstyled -->
                                <div class="cta-two__progress-wrap">
                                    <?php foreach ($settings['progress_line'] as $progress_line) : ?>
                                        <div class="cta-two__progress">
                                            <div class="cta-two__progress-top">
                                                <p><?php echo esc_html($progress_line['progress_line_title']) ?></p>
                                                <span><?php echo esc_html($progress_line['progress_line_count']); ?>%</span>
                                            </div><!-- /.cta-two__progress__top -->
                                            <div class="cta-two__progress-line">
                                                <span class="wow fadeInLeft" style="width: <?php echo esc_attr($progress_line['progress_line_count']) ?>%;"></span>
                                            </div><!-- /.cta-two__progress-line -->
                                        </div><!-- /.cta-two__progress -->
                                    <?php endforeach; ?>
                                </div><!-- /.cta-two__progress-wrap -->
                            </div><!-- /.cta-two__content -->
                        </div><!-- /.col-lg-5 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.cta-two -->
        <?php endif; ?>

        <?php if ('two' === $settings['layout_type']) : ?>
            <section class="cta-two__layout-two">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="cta-two__layout-two-shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 clearfix">
                            <img src="<?php echo esc_url($settings['image']['url']) ?>" alt="" class="cta-two__layout-two-moc">
                        </div><!-- /.col-lg-6 -->
                        <div class="col-lg-6">
                            <div class="cta-two__layout-two-content">
                                <div class="block-title text-left color-2">
                                    <span class="block-title__bubbles"></span>
                                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                                </div><!-- /.block-title -->
                                <ul class="list-unstyled cta-two__layout-two__list">
                                    <?php foreach ($settings['list_box'] as $list) : ?>
                                        <li><i class="fa fa-check-circle"></i> <?php echo esc_html($list['list_text']); ?></li>
                                    <?php endforeach; ?>
                                </ul><!-- /.list-unstyled -->
                                <div class="cta-two__layout-summery">
                                    <p><?php echo wp_kses($settings['summery'], 'zimed_allowed_tags'); ?></p>
                                </div><!-- /.cta-two__layout-summery -->
                                <div class="row">
                                    <?php foreach ($settings['progress_line'] as $progress_line) : ?>
                                        <div class="col-md-6">
                                            <div class="circle-two__layout-progress">
                                                <div class="circle-two__layout-progress-box">
                                                    <?php
                                                    $count_value = $progress_line['progress_line_count'] / 100;
                                                    ?>
                                                    <div class="circle-progress" data-options='{ "value": <?php echo esc_attr($count_value); ?>,"thickness": 6,"emptyFill": "#ffffff","lineCap": "square", "size": 120, "fill": { "color": "#1393cf" } }'>
                                                    </div><!-- /.circle-progress -->
                                                    <span><?php echo esc_html($progress_line['progress_line_count']); ?>%</span>
                                                </div><!-- /.circle-two__layout-progress-box -->
                                                <div class="circle-two__layout-progress-content">
                                                    <h3><?php echo esc_html($progress_line['progress_line_title']) ?></h3>
                                                </div><!-- /.circle-two__layout-progress-content -->
                                            </div><!-- /.circle-two__layout-progress -->
                                        </div><!-- /.col-md-6 -->

                                    <?php endforeach; ?>

                                </div><!-- /.row -->
                            </div><!-- /.cta-two__layout-two-content -->
                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.cta-two__layout-two -->
        <?php endif; ?>

        <?php if ('three' === $settings['layout_type']) : ?>
            <section class="cta-two__style-three">
                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="cta-two__style-three__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="cta-two__style-three-content">
                                <div class="block-title text-left color-2">
                                    <span class="block-title__bubbles"></span>
                                    <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?></p>
                                    <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?></h3>
                                </div><!-- /.block-title -->
                                <div class="cta-two__style-three__box-wrap">
                                    <?php foreach ($settings['contents_box'] as $box) : ?>
                                        <div class="cta-two__style-three__box icon-box-wrapper">
                                            <div class="cta-two__style-three__box-icon icon-box-with-bubble">
                                                <i class="<?php echo esc_attr($box['content_box_icon']); ?>"></i>
                                            </div><!-- /.cta-two__style-three__box-icon -->
                                            <div class="cta-two__style-three__box-content">
                                                <h3><?php echo wp_kses($box['content_box_title'], 'zimed_allowed_tags'); ?></h3>
                                                <p><?php echo wp_kses($box['content_box_text'], 'zimed_allowed_tags'); ?></p>
                                            </div><!-- /.cta-two__style-three__box-content -->
                                        </div><!-- /.cta-two__style-three__box -->
                                    <?php endforeach; ?>
                                </div><!-- /.cta-two__style-three__box-wrap -->
                                <ul class="list-unstyled cta-two__style-three__list">
                                    <?php foreach ($settings['list_box'] as $list) : ?>
                                        <li><i class="fa fa-check"></i> <?php echo esc_html($list['list_text']); ?></li>
                                    <?php endforeach; ?>
                                </ul><!-- /.list-unstyled -->
                                <div class="cta-two__style-three-summery">
                                    <p><?php echo wp_kses($settings['summery'], 'zimed_allowed_tags'); ?></p>
                                </div><!-- /.cta-two__style-three-summery -->
                            </div><!-- /.cta-two__style-three-content -->
                        </div><!-- /.col-lg-6 -->
                        <div class="col-lg-6 clearfix">
                            <img src="<?php echo esc_url($settings['image']['url']) ?>" alt="" class="cta-two__style-three-moc">
                        </div><!-- /.col-lg-6 -->
                    </div><!-- /.row -->
                </div><!-- /.container -->
            </section><!-- /.cta-two__style-three -->
        <?php endif; ?>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Cta_Two());
