<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Gallery extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-gallery';
    }

    public function get_title()
    {
        return __('Zimed - Gallery', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-grip-horizontal';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'gallery_settings',
            [
                'label' => __('Gallery Settings', 'zimed-core')
            ]
        );


        $this->add_control(
            'col_size',
            [
                'label' => __('Column Size', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'col-xl-12'  => __('One Column', 'zimed-core'),
                    'col-xl-6' => __('Two Column', 'zimed-core'),
                    'col-xl-4' => __('Three Column', 'zimed-core'),
                    'col-xl-3' => __('Four Coumn', 'zimed-core'),
                ],
                'default' => 'col-xl-3',
            ]
        );

        $this->add_control(
            'gallery_images',
            [
                'label' => __('Add Images', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="gallery-one">
            <div class="container">
                <div class="row">
                    <?php foreach ($settings['gallery_images'] as $gallery_image) : ?>
                        <div class="<?php echo esc_attr($settings['col_size']); ?> col-md-6 col-sm-12">
                            <div class="gallery-one__single">
                                <?php echo wp_get_attachment_image($gallery_image['id'], "zimed_core_370x417", "", array("class" => "img-fluid"));  ?>
                                <div class="gallery-one__content">
                                    <a class="image-link" href="<?php echo esc_url($gallery_image['url']); ?>">+</a>
                                </div><!-- /.gallery-one__content -->
                            </div><!-- /.gallery-one__single -->
                        </div><!-- /.<?php echo esc_attr($settings['col_size']); ?> -->
                    <?php endforeach; ?>
                </div><!-- /.row -->
            </div><!-- /.container -->
        </section><!-- /.gallery-one -->

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Gallery());
