<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Pricing extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-pricing';
    }

    public function get_title()
    {
        return __('Zimed - Pricing', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-dollar';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'block',
            [
                'label' => __('Block Title', 'zimed-core')
            ]
        );

        $this->add_control(
            'block_title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'block_content',
            [
                'label' => __('Add Content', 'zimed-core'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Contents', 'zimed-core')
            ]
        );

        $this->add_control(
            'col_size',
            [
                'label' => __('Column Size', 'zeino-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'col-lg-12'  => __('One Column', 'zeino-core'),
                    'col-lg-6' => __('Two Column', 'zeino-core'),
                    'col-lg-4' => __('Three Column', 'zeino-core'),
                    'col-lg-3' => __('Four Coumn', 'zeino-core'),
                ],
                'default' => 'col-lg-4',
            ]
        );

        $this->add_control(
            'block_type',
            [
                'label' => __('Layout Type', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'tabbed'  => __('Tabbed Style', 'zimed-core'),
                    'normal' => __('Columns Style', 'zimed-core'),
                ],
                'default' => 'tabbed',
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('Post Count', 'zimed-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 8,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 3,
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_bg',
            [
                'label' => __('Section Shapes', 'zimed-core')
            ]
        );

        $this->add_control(
            'bg_shapes',
            [
                'label' => __('Background Shapes', 'zimed-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <?php if ('tabbed' == $settings['block_type']) : ?>
            <section class="pricing-one">

                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="pricing-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <?php if (!empty($settings['block_title'])) : ?>
                        <div class="block-title text-center color-4">
                            <span class="block-title__bubbles"></span>
                            <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                            <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                        </div><!-- /.block-title -->
                    <?php endif; ?>
                    <?php if ('tabbed' == $settings['block_type']) : ?>
                        <?php
                        $terms = get_terms('pricing_cat');
                        if (!empty($terms) && !is_wp_error($terms)) {
                            echo '<ul class="list-inline text-center switch-toggler-list" role="tablist" id="switch-toggle-tab">';

                            $list_count = 1;
                            $list_active_class = '';
                            foreach ($terms as $term) {
                                if ($list_count == 1) {
                                    $list_active_class = 'active';
                                } else {
                                    $list_active_class = '';
                                }
                                echo '<li class="' . esc_attr($term->slug) . ' ' .  esc_attr($list_active_class) . '"><a href="#' . $term->slug . '">' . $term->name . '</a></li>';

                                ++$list_count;
                            }
                            echo '<li>
                        <!-- Rounded switch -->
                        <label class="switch">
                            <span class="slider round"></span>
                        </label>
                    </li> </ul><!-- /.list-inline -->';
                        }
                        ?>

                    <?php endif; ?>
                    <div class="tabed-content">
                        <?php
                        $terms = get_terms('pricing_cat');
                        $count = 1;
                        $active_class = '';
                        foreach ($terms as $term) : ?>

                            <?php
                            if ($count == 1) {
                                $active_class = 'active';
                            } else {
                                $active_class = '';
                            }
                            ?>

                            <div id="<?php echo esc_attr($term->slug); ?>" class="pricing-box <?php echo esc_attr($active_class); ?>">
                                <div class="row">
                                    <?php
                                    $pricing_query = new \WP_Query(array(
                                        'post_type' => 'pricing',
                                        'orderby' => 'date',
                                        'order' => 'ASC',
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'pricing_cat',
                                                'field'    => 'slug',
                                                'terms'    => $term->slug,
                                            ),
                                        ),
                                        'posts_per_page' => $settings['post_count']['size']
                                    ));
                                    ?>
                                    <?php while ($pricing_query->have_posts()) : ?>
                                        <?php $pricing_query->the_post(); ?>
                                        <div class="<?php echo esc_attr($settings['col_size']); ?> <?php echo esc_attr(('3' < $settings['post_count']['size']) ? 'col-md-6' : 'col-md-12'); ?> col-sm-12">
                                            <div class="pricing-one__single">
                                                <img src="<?php echo esc_attr(ZIMED_CORE_DIRECTORY_URL) ?>assets/images/price-1-line-1.png" alt="" class="pricing-one__line">
                                                <div class="pricing-one__inner">
                                                    <div class="pricing-one__icon-wrap">
                                                        <i class="<?php echo esc_attr(get_post_meta(get_the_ID(), '_zimed_pricing_icon', true)) ?> pricing-one__icon"></i>
                                                    </div><!-- /.pricing-one__icon-wrap -->
                                                    <p><?php the_title(); ?></p>
                                                    <h3><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_currency', true)) ?><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_renewal_fee', true)) ?></h3>
                                                    <?php
                                                    $pricing_options = get_post_meta(get_the_ID(), '_zimed_pricing_options', true);

                                                    ?>
                                                    <div class="pricing-one__bottom">
                                                        <ul class="list-unstyled pricing-one__list">
                                                            <?php
                                                            foreach ($pricing_options as $pricing_option) : ?>
                                                                <li><i class="fa fa-check"></i> <?php echo esc_html($pricing_option); ?></li>

                                                            <?php endforeach; ?>
                                                        </ul><!-- /.pricing-one__list list-unstyled -->
                                                        <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_zimed_pricing_btn_url', true)); ?>" class="thm-btn pricing-one__btn"><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_btn_label', true)); ?></a><!-- /.thm-btn -->
                                                        <span><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_tagline', true)); ?></span>
                                                    </div><!-- /.pricing-one__bottom -->
                                                </div><!-- /.pricing-one__single-inner -->
                                            </div><!-- /.pricing-one__single -->
                                        </div><!-- /.col-lg-4 -->
                                    <?php endwhile; ?>
                                    <?php wp_reset_postdata(); ?>
                                </div><!-- /.row -->
                            </div><!-- /#<?php echo esc_attr($term->slug); ?> -->
                        <?php ++$count;
                        endforeach; ?>
                    </div><!-- /.tabed-content -->

                </div><!-- /.container -->
            </section><!-- /.pricing-one -->
        <?php endif; ?>
        <?php if ('normal' == $settings['block_type']) : ?>
            <section class="pricing-one pricing-one__normal-layout">

                <?php $bg_shapes_count = 1;
                foreach ($settings['bg_shapes'] as $bg_shape) {
                    echo '<img src="' . $bg_shape['url'] . '" class="pricing-one__shape-' . $bg_shapes_count . '" alt="">';
                    $bg_shapes_count++;
                }
                ?>
                <div class="container">
                    <?php if (!empty($settings['block_title'])) : ?>
                        <div class="block-title text-center">
                            <span class="block-title__bubbles"></span>
                            <p><?php echo wp_kses($settings['block_content'], 'zimed_allowed_tags'); ?> </p>
                            <h3><?php echo wp_kses($settings['block_title'], 'zimed_allowed_tags'); ?> </h3>
                        </div><!-- /.block-title -->
                    <?php endif; ?>

                    <div class="row">
                        <?php
                        $pricing_normal_query = new \WP_Query(array(
                            'post_type' => 'pricing',
                            'orderby' => 'date',
                            'order' => 'ASC',
                            'posts_per_page' => $settings['post_count']['size']
                        ));

                        ?>
                        <?php while ($pricing_normal_query->have_posts()) : ?>
                            <?php $pricing_normal_query->the_post(); ?>
                            <div class="<?php echo esc_attr($settings['col_size']); ?> <?php echo esc_attr(('3' < $settings['post_count']['size']) ? 'col-md-6' : 'col-md-12'); ?> col-sm-12">
                                <div class="pricing-one__single">
                                    <img src="<?php echo esc_attr(ZIMED_CORE_DIRECTORY_URL) ?>assets/images/price-1-line-1.png" alt="" class="pricing-one__line">
                                    <div class="pricing-one__inner">
                                        <div class="pricing-one__icon-wrap">
                                            <i class="<?php echo esc_attr(get_post_meta(get_the_ID(), '_zimed_pricing_icon', true)) ?> pricing-one__icon"></i>
                                        </div><!-- /.pricing-one__icon-wrap -->
                                        <p><?php the_title(); ?></p>
                                        <h3><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_currency', true)) ?><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_renewal_fee', true)) ?></h3>
                                        <?php
                                        $pricing_options = get_post_meta(get_the_ID(), '_zimed_pricing_options', true);

                                        ?>
                                        <div class="pricing-one__bottom">
                                            <ul class="list-unstyled pricing-one__list">
                                                <?php
                                                foreach ($pricing_options as $pricing_option) : ?>
                                                    <li><i class="fa fa-check"></i> <?php echo esc_html($pricing_option); ?></li>

                                                <?php endforeach; ?>
                                            </ul><!-- /.pricing-one__list list-unstyled -->
                                            <a href="<?php echo esc_url(get_post_meta(get_the_ID(), '_zimed_pricing_btn_url', true)); ?>" class="thm-btn pricing-one__btn"><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_btn_label', true)); ?></a><!-- /.thm-btn -->
                                            <span><?php echo esc_html(get_post_meta(get_the_ID(), '_zimed_pricing_tagline', true)); ?></span>
                                        </div><!-- /.pricing-one__bottom -->
                                    </div><!-- /.pricing-one__single-inner -->
                                </div><!-- /.pricing-one__single -->

                            </div><!-- /.col-lg-4 -->
                        <?php endwhile; ?>
                        <?php wp_reset_postdata(); ?>
                    </div><!-- /.row -->

                </div><!-- /.container -->
            </section><!-- /.pricing-one -->
        <?php endif; ?>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Pricing());
