<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Section_Shapes extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-section-shapes';
    }

    public function get_title()
    {
        return __('Zimed - Shapes Gallery', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-th-large';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'settings',
            [
                'label' => __('Settings', 'zimed-core')
            ]
        );

        $repeater = new Repeater();


        $repeater->add_control(
            'shape_image',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $repeater->add_control(
            'shape_image_class',
            [
                'label' => __('Add class', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'top_position',
            [
                'label' => __('Top Position', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'bottom_position',
            [
                'label' => __('Bottom Position', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'bottom: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'left_position',
            [
                'label' => __('Left Position', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'right_position',
            [
                'label' => __('Right Position', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'right: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'shapes_images',
            [
                'label' => __('Imaes List', 'zimed-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ shape_image.id }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
    <?php $bg_shapes_count = 1;
        foreach ($settings['shapes_images'] as $bg_shape) {
            echo '<img src="' . $bg_shape['shape_image']['url'] . '" class="section-shapes__bg-shape-' . $bg_shapes_count . ' ' . $bg_shape['shape_image_class'] . '" alt="">';
            $bg_shapes_count++;
        }
    ?>
<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Section_Shapes());
