<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Social extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-social-1';
    }

    public function get_title()
    {
        return __('Zimed - Social Icon', 'zeino-core');
    }

    public function get_icon()
    {
        return 'fa fa-facebook-f';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'social_settings',
            [
                'label' => __('Social Icon Settings', 'zeino-core')
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_icon',
            [
                'label' => __('Social Icon', 'zeino-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => zimed_get_fa_icons(),
                'default' => 'fa-facebook-f',

            ]
        );


        $repeater->add_control(
            'social_url',
            [
                'label' => __('Link', 'zeino-core'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://example.com', 'zeino-core'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );



        $this->add_control(
            'social_icons',
            [
                'label' => __('Icons List', 'zeino-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'social_icon' => 'fa-facebook-f',
                        'social_url' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                    [
                        'social_icon' => 'fa-twitter',
                        'social_url' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],

                ],
                'title_field' => '{{{ social_icon }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>


        <div class="site-footer__social">
            <?php foreach ($settings['social_icons'] as $icon) : ?>
                <a class="fab <?php echo esc_attr($icon['social_icon']) ?>" href="<?php echo esc_url($icon['social_url']['url']); ?>"></a>
            <?php endforeach; ?>
        </div><!-- /.site-footer__social -->



<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Social());
