<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Widget_Zimed_Video extends Widget_Base
{

    public function get_name()
    {
        return 'zimed-video';
    }

    public function get_title()
    {
        return __('Zimed - Video', 'zimed-core');
    }

    public function get_icon()
    {
        return 'fa fa-play-circle-o';
    }

    public function get_categories()
    {
        return ['zimed-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content',
            [
                'label' => __('Contents', 'zimed-core')
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label' => __('Layout Styles', 'zimed-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_one'  => __('Layout One', 'zimed-core'),
                    'style_two'  => __('Layout Two', 'zimed-core'),
                ],
                'default' => 'style_one',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Add Title', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'url',
            [
                'label' => __('Add Video URL', 'zimed-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'thumbnail',
            [
                'label' => __('Add Image', 'zimed-core'),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <?php if ('style_one' === $settings['layout_style']) : ?>
            <section class="video-one">
                <div class="container">
                    <div class="video-one__box wow fadeInUp" data-wow-duration="1500ms" style="background-image: url(<?php echo esc_attr($settings['thumbnail']['url']) ?>);">
                        <div class="video-one__content">
                            <a href="<?php echo esc_url($settings['url']) ?>" class="video-popup"><i class="fa fa-play"></i></a>
                            <h3><?php echo wp_kses($settings['title'], 'zimed_allowed_tags'); ?></h3>
                        </div><!-- /.video-one__content -->
                    </div><!-- /.video-one__box -->
                </div><!-- /.container -->
            </section><!-- /.video-one -->
        <?php endif; ?>

        <?php if ('style_two' === $settings['layout_style']) : ?>
            <section class="video-two jarallax" data-jarallax data-speed="0.5" data-imgPosition="50% 80%">
                <img src="<?php echo esc_attr($settings['thumbnail']['url']) ?>" alt="<?php echo esc_attr($settings['title']); ?>" class="jarallax-img">
                <div class="container">
                    <div class="video-two__content text-center">
                        <a href="<?php echo esc_url($settings['url']) ?>" class="video-popup"><i class="fa fa-play"></i></a>
                        <h3><?php echo wp_kses($settings['title'], 'zimed_allowed_tags'); ?></h3>
                    </div><!-- /.video-two__content -->
                </div><!-- /.container -->
            </section><!-- /.video-two -->
        <?php endif; ?>

<?php
    }
}

Plugin::instance()->widgets_manager->register(new Widget_Zimed_Video());
