<?php
/*
Plugin Name: Zimed Core
Plugin URI:  http://layerdrops.com
Description: This plugin enables the core features to this theme. You must have to install this plugin to work with the theme.
Version:     2.0
Author:      Layerdrops
Author URI:  http://layerdrops.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: zimed-core
Domain Path: /languages
*/

// don't load directly
if (!defined('ABSPATH')) die('-1');

define('ZIMED_CORE_DIRECTORY_PATH', plugin_dir_path(__FILE__));
define('ZIMED_CORE_DIRECTORY_URL', plugin_dir_url(__FILE__));

add_action('plugins_loaded', 'zimedcore_load_textdomain');
function zimedcore_load_textdomain()
{
    load_plugin_textdomain('zimed-core', false, basename(dirname(__FILE__)) . '/languages');
}




/**
 * zimed core functions
 */
require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-helper/custom-functions.php';


/*
* zimed post type
*/

require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-post-type/zimed.footer.pt.php';
require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-post-type/zimed.team.pt.php';
require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-post-type/zimed.pricing.pt.php';

/**
 * Implement Metabox feature.
 */
require_once ZIMED_CORE_DIRECTORY_PATH . '/inc/cmb2-metaboxes.php';
require_once ZIMED_CORE_DIRECTORY_PATH . '/inc/pricing-metaboxes.php';

/**
 * Enqueue scripts and styles.
 */
function zimed_core_scripts()
{
    wp_enqueue_style('owl-carousel', ZIMED_CORE_DIRECTORY_URL . 'assets/css/owl.carousel.css', array(), '2.x');
    wp_enqueue_style('owl-carousel-theme', ZIMED_CORE_DIRECTORY_URL . 'assets/css/owl.theme.default.min.css', array(), '2.x');
    wp_enqueue_style('magnific-popup', ZIMED_CORE_DIRECTORY_URL . 'assets/css/magnific-popup.css', array(), '1.1.0');
    wp_enqueue_style('jquery-bx-slider', ZIMED_CORE_DIRECTORY_URL . 'assets/css/jquery.bxslider.min.css', array(), '4.2.5');
    wp_enqueue_style('jarallax', ZIMED_CORE_DIRECTORY_URL . 'assets/css/jarallax.css', array(), '1.12.4');


    wp_enqueue_script('waypoint', ZIMED_CORE_DIRECTORY_URL . 'assets/js/waypoints.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('counterup', ZIMED_CORE_DIRECTORY_URL . 'assets/js/jquery.counterup.min.js', array('jquery'), '1.0', true);

    wp_enqueue_script('magnific-popup', ZIMED_CORE_DIRECTORY_URL . 'assets/js/jquery.magnific-popup.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('owl-carousel', ZIMED_CORE_DIRECTORY_URL . 'assets/js/owl.carousel.min.js', array('jquery'), '2.0', true);
    wp_enqueue_script('jquery-ajaxchimp', ZIMED_CORE_DIRECTORY_URL . 'assets/js/jquery.ajaxchimp.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-bx-slider', ZIMED_CORE_DIRECTORY_URL . 'assets/js/jquery.bxslider.min.js', array('jquery'), '4.2.5', true);
    wp_enqueue_script('jquery-appear', ZIMED_CORE_DIRECTORY_URL . 'assets/js/jquery.appear.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-circle-progress', ZIMED_CORE_DIRECTORY_URL . 'assets/js/jquery-circle-progress.min.js', array('jquery'), '1.2.2', true);
    wp_enqueue_script('wow', ZIMED_CORE_DIRECTORY_URL . 'assets/js/wow.js', array('jquery'), '1.0', true);
    wp_enqueue_script('jarallax', ZIMED_CORE_DIRECTORY_URL . 'assets/js/jarallax.min.js', array('jquery'), '1.12.4', true);
    wp_enqueue_script('zimed-core-script', ZIMED_CORE_DIRECTORY_URL . 'assets/js/zimed-core.js', array('jquery'), time(), true);
}
add_action('wp_enqueue_scripts', 'zimed_core_scripts');


// import elementor widgets

require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-helper/elementor-category-init.php';

function zimedcore_register_elementor_widgets()
{
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/footer-about.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/section-shapes.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/social-icons.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/footer-subscribe.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/blog-one.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/faq-one.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/brand.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/testimonials.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/screenshots.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/pricing.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/funfact.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/video-one.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/cta-one.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/cta-two.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/cta-three.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/cta-four.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/service-one.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/service-two.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/banner-one.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/team.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/feature.php';
    require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/gallery.php';
    if (function_exists('wpcf7')) {
        require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/contact-one.php';
        require_once ZIMED_CORE_DIRECTORY_PATH . '/zimed-addon/contact-form-7.php';
    }
}

add_action('elementor/widgets/widgets_registered', 'zimedcore_register_elementor_widgets');
